package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyWorkspacePropertiesRequest(
    workspaceId: WorkspaceId,
    workspaceProperties: zio.aws.workspaces.model.WorkspaceProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest = {
    import ModifyWorkspacePropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .workspaceProperties(workspaceProperties.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest
      .wrap(buildAwsValue())
}
object ModifyWorkspacePropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest =
      zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest(
        workspaceId,
        workspaceProperties.asEditable
      )
    def workspaceId: WorkspaceId
    def workspaceProperties
        : zio.aws.workspaces.model.WorkspaceProperties.ReadOnly
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getWorkspaceProperties: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.WorkspaceProperties.ReadOnly
    ] = ZIO.succeed(workspaceProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest
  ) extends zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val workspaceProperties
        : zio.aws.workspaces.model.WorkspaceProperties.ReadOnly =
      zio.aws.workspaces.model.WorkspaceProperties
        .wrap(impl.workspaceProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest
  ): zio.aws.workspaces.model.ModifyWorkspacePropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
