package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClientBrandingResponse(
    deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse = {
    import DescribeClientBrandingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse
      .builder()
      .optionallyWith(deviceTypeWindows.map(value => value.buildAwsValue()))(
        _.deviceTypeWindows
      )
      .optionallyWith(deviceTypeOsx.map(value => value.buildAwsValue()))(
        _.deviceTypeOsx
      )
      .optionallyWith(deviceTypeAndroid.map(value => value.buildAwsValue()))(
        _.deviceTypeAndroid
      )
      .optionallyWith(deviceTypeIos.map(value => value.buildAwsValue()))(
        _.deviceTypeIos
      )
      .optionallyWith(deviceTypeLinux.map(value => value.buildAwsValue()))(
        _.deviceTypeLinux
      )
      .optionallyWith(deviceTypeWeb.map(value => value.buildAwsValue()))(
        _.deviceTypeWeb
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeClientBrandingResponse
      .wrap(buildAwsValue())
}
object DescribeClientBrandingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeClientBrandingResponse =
      zio.aws.workspaces.model.DescribeClientBrandingResponse(
        deviceTypeWindows.map(value => value.asEditable),
        deviceTypeOsx.map(value => value.asEditable),
        deviceTypeAndroid.map(value => value.asEditable),
        deviceTypeIos.map(value => value.asEditable),
        deviceTypeLinux.map(value => value.asEditable),
        deviceTypeWeb.map(value => value.asEditable)
      )
    def deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ]
    def getDeviceTypeWindows: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeWindows", deviceTypeWindows)
    def getDeviceTypeOsx: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeOsx", deviceTypeOsx)
    def getDeviceTypeAndroid: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeAndroid", deviceTypeAndroid)
    def getDeviceTypeIos: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeIos", deviceTypeIos)
    def getDeviceTypeLinux: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeLinux", deviceTypeLinux)
    def getDeviceTypeWeb: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeWeb", deviceTypeWeb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse
  ) extends zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly {
    override val deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeWindows())
      .map(value =>
        zio.aws.workspaces.model.DefaultClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeOsx())
      .map(value =>
        zio.aws.workspaces.model.DefaultClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeAndroid())
      .map(value =>
        zio.aws.workspaces.model.DefaultClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeIos())
      .map(value =>
        zio.aws.workspaces.model.IosClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeLinux())
      .map(value =>
        zio.aws.workspaces.model.DefaultClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeWeb())
      .map(value =>
        zio.aws.workspaces.model.DefaultClientBrandingAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse
  ): zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly =
    new Wrapper(impl)
}
