package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  ClientLoginMessage,
  ClientEmail,
  ClientUrl,
  ClientLocale,
  DefaultLogo
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DefaultImportClientBrandingAttributes(
    logo: Optional[DefaultLogo] = Optional.Absent,
    supportEmail: Optional[ClientEmail] = Optional.Absent,
    supportLink: Optional[ClientUrl] = Optional.Absent,
    forgotPasswordLink: Optional[ClientUrl] = Optional.Absent,
    loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes = {
    import DefaultImportClientBrandingAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes
      .builder()
      .optionallyWith(
        logo.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.logo)
      .optionallyWith(
        supportEmail.map(value => ClientEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportLink.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.supportLink)
      .optionallyWith(
        forgotPasswordLink.map(value =>
          ClientUrl.unwrap(value): java.lang.String
        )
      )(_.forgotPasswordLink)
      .optionallyWith(
        loginMessage.map(value =>
          value
            .map({ case (key, value) =>
              (ClientLocale
                .unwrap(key): java.lang.String) -> (ClientLoginMessage
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.loginMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly =
    zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
      .wrap(buildAwsValue())
}
object DefaultImportClientBrandingAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DefaultImportClientBrandingAttributes =
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes(
        logo.map(value => value),
        supportEmail.map(value => value),
        supportLink.map(value => value),
        forgotPasswordLink.map(value => value),
        loginMessage.map(value => value)
      )
    def logo: Optional[DefaultLogo]
    def supportEmail: Optional[ClientEmail]
    def supportLink: Optional[ClientUrl]
    def forgotPasswordLink: Optional[ClientUrl]
    def loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]]
    def getLogo: ZIO[Any, AwsError, DefaultLogo] =
      AwsError.unwrapOptionField("logo", logo)
    def getSupportEmail: ZIO[Any, AwsError, ClientEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("supportLink", supportLink)
    def getForgotPasswordLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("forgotPasswordLink", forgotPasswordLink)
    def getLoginMessage
        : ZIO[Any, AwsError, Map[ClientLocale, ClientLoginMessage]] =
      AwsError.unwrapOptionField("loginMessage", loginMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes
  ) extends zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly {
    override val logo: Optional[DefaultLogo] = zio.aws.core.internal
      .optionalFromNullable(impl.logo())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .DefaultLogo(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val supportEmail: Optional[ClientEmail] = zio.aws.core.internal
      .optionalFromNullable(impl.supportEmail())
      .map(value => zio.aws.workspaces.model.primitives.ClientEmail(value))
    override val supportLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.supportLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val forgotPasswordLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.forgotPasswordLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loginMessage())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workspaces.model.primitives.ClientLocale(
                key
              ) -> zio.aws.workspaces.model.primitives.ClientLoginMessage(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DefaultImportClientBrandingAttributes
  ): zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly =
    new Wrapper(impl)
}
