package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateConnectionAliasRequest(
    connectionString: ConnectionString,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest = {
    import CreateConnectionAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest
      .builder()
      .connectionString(
        ConnectionString.unwrap(connectionString): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateConnectionAliasRequest.ReadOnly =
    zio.aws.workspaces.model.CreateConnectionAliasRequest.wrap(buildAwsValue())
}
object CreateConnectionAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateConnectionAliasRequest =
      zio.aws.workspaces.model.CreateConnectionAliasRequest(
        connectionString,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionString: ConnectionString
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getConnectionString: ZIO[Any, Nothing, ConnectionString] =
      ZIO.succeed(connectionString)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest
  ) extends zio.aws.workspaces.model.CreateConnectionAliasRequest.ReadOnly {
    override val connectionString: ConnectionString =
      zio.aws.workspaces.model.primitives
        .ConnectionString(impl.connectionString())
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest
  ): zio.aws.workspaces.model.CreateConnectionAliasRequest.ReadOnly =
    new Wrapper(impl)
}
