package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionAliasId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectionAliasRequest(aliasId: ConnectionAliasId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest = {
    import DeleteConnectionAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest
      .builder()
      .aliasId(ConnectionAliasId.unwrap(aliasId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeleteConnectionAliasRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteConnectionAliasRequest.wrap(buildAwsValue())
}
object DeleteConnectionAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteConnectionAliasRequest =
      zio.aws.workspaces.model.DeleteConnectionAliasRequest(aliasId)
    def aliasId: ConnectionAliasId
    def getAliasId: ZIO[Any, Nothing, ConnectionAliasId] = ZIO.succeed(aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest
  ) extends zio.aws.workspaces.model.DeleteConnectionAliasRequest.ReadOnly {
    override val aliasId: ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId(impl.aliasId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest
  ): zio.aws.workspaces.model.DeleteConnectionAliasRequest.ReadOnly =
    new Wrapper(impl)
}
