package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait Compute {
  def unwrap: software.amazon.awssdk.services.workspaces.model.Compute
}
object Compute {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.Compute
  ): zio.aws.workspaces.model.Compute = value match {
    case software.amazon.awssdk.services.workspaces.model.Compute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.VALUE =>
      val r = VALUE
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.PERFORMANCE =>
      val r = PERFORMANCE
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.POWER =>
      val r = POWER
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICS =>
      val r = GRAPHICS
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.POWERPRO =>
      val r = POWERPRO
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICSPRO =>
      val r = GRAPHICSPRO
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICS_G4_DN =>
      val r = GRAPHICS_G4DN
      r
    case software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICSPRO_G4_DN =>
      val r = GRAPHICSPRO_G4DN
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.UNKNOWN_TO_SDK_VERSION
  }
  case object VALUE extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.VALUE
  }
  case object STANDARD extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.STANDARD
  }
  case object PERFORMANCE extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.PERFORMANCE
  }
  case object POWER extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.POWER
  }
  case object GRAPHICS extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICS
  }
  case object POWERPRO extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.POWERPRO
  }
  case object GRAPHICSPRO extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICSPRO
  }
  case object GRAPHICS_G4DN extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICS_G4_DN
  }
  case object GRAPHICSPRO_G4DN extends zio.aws.workspaces.model.Compute {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Compute =
      software.amazon.awssdk.services.workspaces.model.Compute.GRAPHICSPRO_G4_DN
  }
}
