package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifySelfservicePermissionsRequest(
    resourceId: DirectoryId,
    selfservicePermissions: zio.aws.workspaces.model.SelfservicePermissions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest = {
    import ModifySelfservicePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .selfservicePermissions(selfservicePermissions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifySelfservicePermissionsRequest.ReadOnly =
    zio.aws.workspaces.model.ModifySelfservicePermissionsRequest
      .wrap(buildAwsValue())
}
object ModifySelfservicePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ModifySelfservicePermissionsRequest =
      zio.aws.workspaces.model.ModifySelfservicePermissionsRequest(
        resourceId,
        selfservicePermissions.asEditable
      )
    def resourceId: DirectoryId
    def selfservicePermissions
        : zio.aws.workspaces.model.SelfservicePermissions.ReadOnly
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getSelfservicePermissions: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.SelfservicePermissions.ReadOnly
    ] = ZIO.succeed(selfservicePermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest
  ) extends zio.aws.workspaces.model.ModifySelfservicePermissionsRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val selfservicePermissions
        : zio.aws.workspaces.model.SelfservicePermissions.ReadOnly =
      zio.aws.workspaces.model.SelfservicePermissions
        .wrap(impl.selfservicePermissions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest
  ): zio.aws.workspaces.model.ModifySelfservicePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
