package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConnectionAliasesResponse(
    connectionAliases: Optional[
      Iterable[zio.aws.workspaces.model.ConnectionAlias]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse = {
    import DescribeConnectionAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse
      .builder()
      .optionallyWith(
        connectionAliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionAliases)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasesResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeConnectionAliasesResponse =
      zio.aws.workspaces.model.DescribeConnectionAliasesResponse(
        connectionAliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectionAliases
        : Optional[List[zio.aws.workspaces.model.ConnectionAlias.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getConnectionAliases: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectionAlias.ReadOnly
    ]] = AwsError.unwrapOptionField("connectionAliases", connectionAliases)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly {
    override val connectionAliases
        : Optional[List[zio.aws.workspaces.model.ConnectionAlias.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionAliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.ConnectionAlias.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse
  ): zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly =
    new Wrapper(impl)
}
