package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWorkspaceImageRequest(imageId: WorkspaceImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest = {
    import DeleteWorkspaceImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest
      .builder()
      .imageId(WorkspaceImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeleteWorkspaceImageRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteWorkspaceImageRequest.wrap(buildAwsValue())
}
object DeleteWorkspaceImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteWorkspaceImageRequest =
      zio.aws.workspaces.model.DeleteWorkspaceImageRequest(imageId)
    def imageId: WorkspaceImageId
    def getImageId: ZIO[Any, Nothing, WorkspaceImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest
  ) extends zio.aws.workspaces.model.DeleteWorkspaceImageRequest.ReadOnly {
    override val imageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest
  ): zio.aws.workspaces.model.DeleteWorkspaceImageRequest.ReadOnly =
    new Wrapper(impl)
}
