package zio.aws.workspaces
import zio.aws.workspaces.model.{
  AssociateConnectionAliasRequest,
  AuthorizeIpRulesRequest,
  DescribeWorkspaceSnapshotsRequest,
  DescribeWorkspacesRequest,
  DescribeWorkspacesConnectionStatusRequest,
  DescribeWorkspaceImagesRequest,
  TerminateWorkspacesRequest,
  MigrateWorkspaceRequest,
  ModifyClientPropertiesRequest,
  CopyWorkspaceImageRequest,
  DeleteTagsRequest,
  ListAvailableManagementCidrRangesRequest,
  DescribeClientBrandingRequest,
  RebuildWorkspacesRequest,
  ModifyWorkspaceCreationPropertiesRequest,
  CreateWorkspacesRequest,
  RebootWorkspacesRequest,
  CreateIpGroupRequest,
  DescribeWorkspaceDirectoriesRequest,
  DescribeConnectClientAddInsRequest,
  DescribeAccountModificationsRequest,
  DescribeConnectionAliasPermissionsRequest,
  ModifyWorkspaceAccessPropertiesRequest,
  DeleteConnectionAliasRequest,
  CreateWorkspaceBundleRequest,
  StartWorkspacesRequest,
  CreateTagsRequest,
  ModifyAccountRequest,
  ModifyWorkspacePropertiesRequest,
  DeleteIpGroupRequest,
  DeleteWorkspaceBundleRequest,
  DescribeConnectionAliasesRequest,
  DeleteConnectClientAddInRequest,
  ImportClientBrandingRequest,
  UpdateConnectClientAddInRequest,
  ImportWorkspaceImageRequest,
  DeleteWorkspaceImageRequest,
  StopWorkspacesRequest,
  DisassociateIpGroupsRequest,
  UpdateRulesOfIpGroupRequest,
  RegisterWorkspaceDirectoryRequest,
  UpdateWorkspaceBundleRequest,
  DescribeWorkspaceImagePermissionsRequest,
  RestoreWorkspaceRequest,
  AssociateIpGroupsRequest,
  DeleteClientBrandingRequest,
  DisassociateConnectionAliasRequest,
  UpdateConnectionAliasPermissionRequest,
  DescribeTagsRequest,
  DescribeIpGroupsRequest,
  CreateUpdatedWorkspaceImageRequest,
  DescribeWorkspaceBundlesRequest,
  DeregisterWorkspaceDirectoryRequest,
  ModifyWorkspaceStateRequest,
  UpdateWorkspaceImagePermissionRequest,
  DescribeClientPropertiesRequest,
  CreateConnectionAliasRequest,
  ModifySelfservicePermissionsRequest,
  CreateConnectClientAddInRequest,
  DescribeAccountRequest,
  RevokeIpRulesRequest
}
import zio.aws.workspaces.model.RegisterWorkspaceDirectoryResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.workspaces.model.primitives.DedicatedTenancyManagementCidrRange
import zio.stream.ZStream
object WorkSpacesMock extends Mock[WorkSpaces] {
  object ModifyWorkspaceProperties
      extends Effect[
        ModifyWorkspacePropertiesRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.ReadOnly
      ]
  object DescribeTags
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly
      ]
  object UpdateRulesOfIpGroup
      extends Effect[
        UpdateRulesOfIpGroupRequest,
        AwsError,
        zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.ReadOnly
      ]
  object UpdateConnectClientAddIn
      extends Effect[
        UpdateConnectClientAddInRequest,
        AwsError,
        zio.aws.workspaces.model.UpdateConnectClientAddInResponse.ReadOnly
      ]
  object DeregisterWorkspaceDirectory
      extends Effect[
        DeregisterWorkspaceDirectoryRequest,
        AwsError,
        zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.ReadOnly
      ]
  object DeleteIpGroup
      extends Effect[
        DeleteIpGroupRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteIpGroupResponse.ReadOnly
      ]
  object DeleteClientBranding
      extends Effect[
        DeleteClientBrandingRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteClientBrandingResponse.ReadOnly
      ]
  object DescribeConnectionAliases
      extends Stream[
        DescribeConnectionAliasesRequest,
        AwsError,
        zio.aws.workspaces.model.ConnectionAlias.ReadOnly
      ]
  object DescribeConnectionAliasesPaginated
      extends Effect[
        DescribeConnectionAliasesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly
      ]
  object ModifyAccount
      extends Effect[
        ModifyAccountRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyAccountResponse.ReadOnly
      ]
  object DescribeAccountModifications
      extends Stream[
        DescribeAccountModificationsRequest,
        AwsError,
        zio.aws.workspaces.model.AccountModification.ReadOnly
      ]
  object DescribeAccountModificationsPaginated
      extends Effect[
        DescribeAccountModificationsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly
      ]
  object DescribeWorkspaceBundles
      extends Stream[
        DescribeWorkspaceBundlesRequest,
        AwsError,
        zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
      ]
  object DescribeWorkspaceBundlesPaginated
      extends Effect[
        DescribeWorkspaceBundlesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly
      ]
  object StartWorkspaces
      extends Effect[
        StartWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.StartWorkspacesResponse.ReadOnly
      ]
  object DescribeClientBranding
      extends Effect[
        DescribeClientBrandingRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly
      ]
  object ModifySelfservicePermissions
      extends Effect[
        ModifySelfservicePermissionsRequest,
        AwsError,
        zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.ReadOnly
      ]
  object DescribeWorkspacesConnectionStatus
      extends Stream[
        DescribeWorkspacesConnectionStatusRequest,
        AwsError,
        zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
      ]
  object DescribeWorkspacesConnectionStatusPaginated
      extends Effect[
        DescribeWorkspacesConnectionStatusRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly
      ]
  object ModifyWorkspaceState
      extends Effect[
        ModifyWorkspaceStateRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyWorkspaceStateResponse.ReadOnly
      ]
  object DeleteConnectionAlias
      extends Effect[
        DeleteConnectionAliasRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteConnectionAliasResponse.ReadOnly
      ]
  object ModifyWorkspaceAccessProperties
      extends Effect[
        ModifyWorkspaceAccessPropertiesRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.ReadOnly
      ]
  object CreateConnectionAlias
      extends Effect[
        CreateConnectionAliasRequest,
        AwsError,
        zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly
      ]
  object RevokeIpRules
      extends Effect[
        RevokeIpRulesRequest,
        AwsError,
        zio.aws.workspaces.model.RevokeIpRulesResponse.ReadOnly
      ]
  object RestoreWorkspace
      extends Effect[
        RestoreWorkspaceRequest,
        AwsError,
        zio.aws.workspaces.model.RestoreWorkspaceResponse.ReadOnly
      ]
  object DescribeConnectionAliasPermissions
      extends Effect[
        DescribeConnectionAliasPermissionsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly,
          zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
        ]
      ]
  object DescribeConnectionAliasPermissionsPaginated
      extends Effect[
        DescribeConnectionAliasPermissionsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly
      ]
  object MigrateWorkspace
      extends Effect[
        MigrateWorkspaceRequest,
        AwsError,
        zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly
      ]
  object UpdateWorkspaceImagePermission
      extends Effect[
        UpdateWorkspaceImagePermissionRequest,
        AwsError,
        zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.ReadOnly
      ]
  object ListAvailableManagementCidrRanges
      extends Stream[
        ListAvailableManagementCidrRangesRequest,
        AwsError,
        DedicatedTenancyManagementCidrRange
      ]
  object ListAvailableManagementCidrRangesPaginated
      extends Effect[
        ListAvailableManagementCidrRangesRequest,
        AwsError,
        zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly
      ]
  object AuthorizeIpRules
      extends Effect[
        AuthorizeIpRulesRequest,
        AwsError,
        zio.aws.workspaces.model.AuthorizeIpRulesResponse.ReadOnly
      ]
  object DescribeWorkspaceImagePermissions
      extends Effect[
        DescribeWorkspaceImagePermissionsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly,
          zio.aws.workspaces.model.ImagePermission.ReadOnly
        ]
      ]
  object DescribeWorkspaceImagePermissionsPaginated
      extends Effect[
        DescribeWorkspaceImagePermissionsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly
      ]
  object DescribeAccount
      extends Effect[
        DescribeAccountRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly
      ]
  object CreateIpGroup
      extends Effect[
        CreateIpGroupRequest,
        AwsError,
        zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly
      ]
  object UpdateWorkspaceBundle
      extends Effect[
        UpdateWorkspaceBundleRequest,
        AwsError,
        zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.ReadOnly
      ]
  object CreateWorkspaceBundle
      extends Effect[
        CreateWorkspaceBundleRequest,
        AwsError,
        zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly
      ]
  object ImportWorkspaceImage
      extends Effect[
        ImportWorkspaceImageRequest,
        AwsError,
        zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly
      ]
  object RegisterWorkspaceDirectory
      extends Effect[RegisterWorkspaceDirectoryRequest, AwsError, ReadOnly]
  object AssociateIpGroups
      extends Effect[
        AssociateIpGroupsRequest,
        AwsError,
        zio.aws.workspaces.model.AssociateIpGroupsResponse.ReadOnly
      ]
  object CreateConnectClientAddIn
      extends Effect[
        CreateConnectClientAddInRequest,
        AwsError,
        zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly
      ]
  object ModifyClientProperties
      extends Effect[
        ModifyClientPropertiesRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyClientPropertiesResponse.ReadOnly
      ]
  object DisassociateConnectionAlias
      extends Effect[
        DisassociateConnectionAliasRequest,
        AwsError,
        zio.aws.workspaces.model.DisassociateConnectionAliasResponse.ReadOnly
      ]
  object StopWorkspaces
      extends Effect[
        StopWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.StopWorkspacesResponse.ReadOnly
      ]
  object DescribeWorkspaces
      extends Stream[
        DescribeWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.Workspace.ReadOnly
      ]
  object DescribeWorkspacesPaginated
      extends Effect[
        DescribeWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly
      ]
  object RebootWorkspaces
      extends Effect[
        RebootWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly
      ]
  object DescribeWorkspaceDirectories
      extends Stream[
        DescribeWorkspaceDirectoriesRequest,
        AwsError,
        zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
      ]
  object DescribeWorkspaceDirectoriesPaginated
      extends Effect[
        DescribeWorkspaceDirectoriesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly
      ]
  object ModifyWorkspaceCreationProperties
      extends Effect[
        ModifyWorkspaceCreationPropertiesRequest,
        AwsError,
        zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.ReadOnly
      ]
  object DescribeWorkspaceSnapshots
      extends Effect[
        DescribeWorkspaceSnapshotsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly
      ]
  object DescribeIpGroups
      extends Stream[
        DescribeIpGroupsRequest,
        AwsError,
        zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly
      ]
  object DescribeIpGroupsPaginated
      extends Effect[
        DescribeIpGroupsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly
      ]
  object CreateUpdatedWorkspaceImage
      extends Effect[
        CreateUpdatedWorkspaceImageRequest,
        AwsError,
        zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly
      ]
  object TerminateWorkspaces
      extends Effect[
        TerminateWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly
      ]
  object CopyWorkspaceImage
      extends Effect[
        CopyWorkspaceImageRequest,
        AwsError,
        zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly
      ]
  object AssociateConnectionAlias
      extends Effect[
        AssociateConnectionAliasRequest,
        AwsError,
        zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly
      ]
  object RebuildWorkspaces
      extends Effect[
        RebuildWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.RebuildWorkspacesResponse.ReadOnly
      ]
  object DeleteTags
      extends Effect[
        DeleteTagsRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteTagsResponse.ReadOnly
      ]
  object DescribeWorkspaceImages
      extends Stream[
        DescribeWorkspaceImagesRequest,
        AwsError,
        zio.aws.workspaces.model.WorkspaceImage.ReadOnly
      ]
  object DescribeWorkspaceImagesPaginated
      extends Effect[
        DescribeWorkspaceImagesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly
      ]
  object CreateWorkspaces
      extends Effect[
        CreateWorkspacesRequest,
        AwsError,
        zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly
      ]
  object DeleteWorkspaceImage
      extends Effect[
        DeleteWorkspaceImageRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteWorkspaceImageResponse.ReadOnly
      ]
  object DeleteConnectClientAddIn
      extends Effect[
        DeleteConnectClientAddInRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteConnectClientAddInResponse.ReadOnly
      ]
  object ImportClientBranding
      extends Effect[
        ImportClientBrandingRequest,
        AwsError,
        zio.aws.workspaces.model.ImportClientBrandingResponse.ReadOnly
      ]
  object DeleteWorkspaceBundle
      extends Effect[
        DeleteWorkspaceBundleRequest,
        AwsError,
        zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.ReadOnly
      ]
  object DescribeConnectClientAddIns
      extends Stream[
        DescribeConnectClientAddInsRequest,
        AwsError,
        zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
      ]
  object DescribeConnectClientAddInsPaginated
      extends Effect[
        DescribeConnectClientAddInsRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly
      ]
  object DisassociateIpGroups
      extends Effect[
        DisassociateIpGroupsRequest,
        AwsError,
        zio.aws.workspaces.model.DisassociateIpGroupsResponse.ReadOnly
      ]
  object DescribeClientProperties
      extends Effect[
        DescribeClientPropertiesRequest,
        AwsError,
        zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly
      ]
  object UpdateConnectionAliasPermission
      extends Effect[
        UpdateConnectionAliasPermissionRequest,
        AwsError,
        zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.ReadOnly
      ]
  object CreateTags
      extends Effect[
        CreateTagsRequest,
        AwsError,
        zio.aws.workspaces.model.CreateTagsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, WorkSpaces] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new WorkSpaces {
          val api: WorkSpacesAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : WorkSpaces = this
          def modifyWorkspaceProperties(
              request: ModifyWorkspacePropertiesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.ReadOnly
          ] = proxy(ModifyWorkspaceProperties, request)
          def describeTags(request: DescribeTagsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly
          ] = proxy(DescribeTags, request)
          def updateRulesOfIpGroup(request: UpdateRulesOfIpGroupRequest): IO[
            AwsError,
            zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.ReadOnly
          ] = proxy(UpdateRulesOfIpGroup, request)
          def updateConnectClientAddIn(
              request: UpdateConnectClientAddInRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.UpdateConnectClientAddInResponse.ReadOnly
          ] = proxy(UpdateConnectClientAddIn, request)
          def deregisterWorkspaceDirectory(
              request: DeregisterWorkspaceDirectoryRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.ReadOnly
          ] = proxy(DeregisterWorkspaceDirectory, request)
          def deleteIpGroup(request: DeleteIpGroupRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteIpGroupResponse.ReadOnly
          ] = proxy(DeleteIpGroup, request)
          def deleteClientBranding(request: DeleteClientBrandingRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteClientBrandingResponse.ReadOnly
          ] = proxy(DeleteClientBranding, request)
          def describeConnectionAliases(
              request: DescribeConnectionAliasesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.ConnectionAlias.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeConnectionAliases, request))
          def describeConnectionAliasesPaginated(
              request: DescribeConnectionAliasesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly
          ] = proxy(DescribeConnectionAliasesPaginated, request)
          def modifyAccount(request: ModifyAccountRequest): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyAccountResponse.ReadOnly
          ] = proxy(ModifyAccount, request)
          def describeAccountModifications(
              request: DescribeAccountModificationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.AccountModification.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccountModifications, request))
          def describeAccountModificationsPaginated(
              request: DescribeAccountModificationsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly
          ] = proxy(DescribeAccountModificationsPaginated, request)
          def describeWorkspaceBundles(
              request: DescribeWorkspaceBundlesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeWorkspaceBundles, request))
          def describeWorkspaceBundlesPaginated(
              request: DescribeWorkspaceBundlesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly
          ] = proxy(DescribeWorkspaceBundlesPaginated, request)
          def startWorkspaces(request: StartWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.StartWorkspacesResponse.ReadOnly
          ] = proxy(StartWorkspaces, request)
          def describeClientBranding(
              request: DescribeClientBrandingRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly
          ] = proxy(DescribeClientBranding, request)
          def modifySelfservicePermissions(
              request: ModifySelfservicePermissionsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.ReadOnly
          ] = proxy(ModifySelfservicePermissions, request)
          def describeWorkspacesConnectionStatus(
              request: DescribeWorkspacesConnectionStatusRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeWorkspacesConnectionStatus, request))
          def describeWorkspacesConnectionStatusPaginated(
              request: DescribeWorkspacesConnectionStatusRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly
          ] = proxy(DescribeWorkspacesConnectionStatusPaginated, request)
          def modifyWorkspaceState(request: ModifyWorkspaceStateRequest): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyWorkspaceStateResponse.ReadOnly
          ] = proxy(ModifyWorkspaceState, request)
          def deleteConnectionAlias(request: DeleteConnectionAliasRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteConnectionAliasResponse.ReadOnly
          ] = proxy(DeleteConnectionAlias, request)
          def modifyWorkspaceAccessProperties(
              request: ModifyWorkspaceAccessPropertiesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.ReadOnly
          ] = proxy(ModifyWorkspaceAccessProperties, request)
          def createConnectionAlias(request: CreateConnectionAliasRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly
          ] = proxy(CreateConnectionAlias, request)
          def revokeIpRules(request: RevokeIpRulesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.RevokeIpRulesResponse.ReadOnly
          ] = proxy(RevokeIpRules, request)
          def restoreWorkspace(request: RestoreWorkspaceRequest): IO[
            AwsError,
            zio.aws.workspaces.model.RestoreWorkspaceResponse.ReadOnly
          ] = proxy(RestoreWorkspace, request)
          def describeConnectionAliasPermissions(
              request: DescribeConnectionAliasPermissionsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly,
            zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
          ]] = proxy(DescribeConnectionAliasPermissions, request)
          def describeConnectionAliasPermissionsPaginated(
              request: DescribeConnectionAliasPermissionsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly
          ] = proxy(DescribeConnectionAliasPermissionsPaginated, request)
          def migrateWorkspace(request: MigrateWorkspaceRequest): IO[
            AwsError,
            zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly
          ] = proxy(MigrateWorkspace, request)
          def updateWorkspaceImagePermission(
              request: UpdateWorkspaceImagePermissionRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.ReadOnly
          ] = proxy(UpdateWorkspaceImagePermission, request)
          def listAvailableManagementCidrRanges(
              request: ListAvailableManagementCidrRangesRequest
          ): ZStream[Any, AwsError, DedicatedTenancyManagementCidrRange] =
            rts.unsafeRun(proxy(ListAvailableManagementCidrRanges, request))
          def listAvailableManagementCidrRangesPaginated(
              request: ListAvailableManagementCidrRangesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly
          ] = proxy(ListAvailableManagementCidrRangesPaginated, request)
          def authorizeIpRules(request: AuthorizeIpRulesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.AuthorizeIpRulesResponse.ReadOnly
          ] = proxy(AuthorizeIpRules, request)
          def describeWorkspaceImagePermissions(
              request: DescribeWorkspaceImagePermissionsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly,
            zio.aws.workspaces.model.ImagePermission.ReadOnly
          ]] = proxy(DescribeWorkspaceImagePermissions, request)
          def describeWorkspaceImagePermissionsPaginated(
              request: DescribeWorkspaceImagePermissionsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly
          ] = proxy(DescribeWorkspaceImagePermissionsPaginated, request)
          def describeAccount(request: DescribeAccountRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly
          ] = proxy(DescribeAccount, request)
          def createIpGroup(request: CreateIpGroupRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly
          ] = proxy(CreateIpGroup, request)
          def updateWorkspaceBundle(request: UpdateWorkspaceBundleRequest): IO[
            AwsError,
            zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.ReadOnly
          ] = proxy(UpdateWorkspaceBundle, request)
          def createWorkspaceBundle(request: CreateWorkspaceBundleRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly
          ] = proxy(CreateWorkspaceBundle, request)
          def importWorkspaceImage(request: ImportWorkspaceImageRequest): IO[
            AwsError,
            zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly
          ] = proxy(ImportWorkspaceImage, request)
          def registerWorkspaceDirectory(
              request: RegisterWorkspaceDirectoryRequest
          ): IO[AwsError, ReadOnly] = proxy(RegisterWorkspaceDirectory, request)
          def associateIpGroups(request: AssociateIpGroupsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.AssociateIpGroupsResponse.ReadOnly
          ] = proxy(AssociateIpGroups, request)
          def createConnectClientAddIn(
              request: CreateConnectClientAddInRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly
          ] = proxy(CreateConnectClientAddIn, request)
          def modifyClientProperties(
              request: ModifyClientPropertiesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyClientPropertiesResponse.ReadOnly
          ] = proxy(ModifyClientProperties, request)
          def disassociateConnectionAlias(
              request: DisassociateConnectionAliasRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DisassociateConnectionAliasResponse.ReadOnly
          ] = proxy(DisassociateConnectionAlias, request)
          def stopWorkspaces(request: StopWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.StopWorkspacesResponse.ReadOnly
          ] = proxy(StopWorkspaces, request)
          def describeWorkspaces(request: DescribeWorkspacesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.Workspace.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeWorkspaces, request))
          def describeWorkspacesPaginated(
              request: DescribeWorkspacesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly
          ] = proxy(DescribeWorkspacesPaginated, request)
          def rebootWorkspaces(request: RebootWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly
          ] = proxy(RebootWorkspaces, request)
          def describeWorkspaceDirectories(
              request: DescribeWorkspaceDirectoriesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeWorkspaceDirectories, request))
          def describeWorkspaceDirectoriesPaginated(
              request: DescribeWorkspaceDirectoriesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly
          ] = proxy(DescribeWorkspaceDirectoriesPaginated, request)
          def modifyWorkspaceCreationProperties(
              request: ModifyWorkspaceCreationPropertiesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.ReadOnly
          ] = proxy(ModifyWorkspaceCreationProperties, request)
          def describeWorkspaceSnapshots(
              request: DescribeWorkspaceSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly
          ] = proxy(DescribeWorkspaceSnapshots, request)
          def describeIpGroups(request: DescribeIpGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeIpGroups, request))
          def describeIpGroupsPaginated(request: DescribeIpGroupsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly
          ] = proxy(DescribeIpGroupsPaginated, request)
          def createUpdatedWorkspaceImage(
              request: CreateUpdatedWorkspaceImageRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly
          ] = proxy(CreateUpdatedWorkspaceImage, request)
          def terminateWorkspaces(request: TerminateWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly
          ] = proxy(TerminateWorkspaces, request)
          def copyWorkspaceImage(request: CopyWorkspaceImageRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly
          ] = proxy(CopyWorkspaceImage, request)
          def associateConnectionAlias(
              request: AssociateConnectionAliasRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly
          ] = proxy(AssociateConnectionAlias, request)
          def rebuildWorkspaces(request: RebuildWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.RebuildWorkspacesResponse.ReadOnly
          ] = proxy(RebuildWorkspaces, request)
          def deleteTags(request: DeleteTagsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteTagsResponse.ReadOnly
          ] = proxy(DeleteTags, request)
          def describeWorkspaceImages(
              request: DescribeWorkspaceImagesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.WorkspaceImage.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeWorkspaceImages, request))
          def describeWorkspaceImagesPaginated(
              request: DescribeWorkspaceImagesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly
          ] = proxy(DescribeWorkspaceImagesPaginated, request)
          def createWorkspaces(request: CreateWorkspacesRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly
          ] = proxy(CreateWorkspaces, request)
          def deleteWorkspaceImage(request: DeleteWorkspaceImageRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteWorkspaceImageResponse.ReadOnly
          ] = proxy(DeleteWorkspaceImage, request)
          def deleteConnectClientAddIn(
              request: DeleteConnectClientAddInRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteConnectClientAddInResponse.ReadOnly
          ] = proxy(DeleteConnectClientAddIn, request)
          def importClientBranding(request: ImportClientBrandingRequest): IO[
            AwsError,
            zio.aws.workspaces.model.ImportClientBrandingResponse.ReadOnly
          ] = proxy(ImportClientBranding, request)
          def deleteWorkspaceBundle(request: DeleteWorkspaceBundleRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.ReadOnly
          ] = proxy(DeleteWorkspaceBundle, request)
          def describeConnectClientAddIns(
              request: DescribeConnectClientAddInsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeConnectClientAddIns, request))
          def describeConnectClientAddInsPaginated(
              request: DescribeConnectClientAddInsRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly
          ] = proxy(DescribeConnectClientAddInsPaginated, request)
          def disassociateIpGroups(request: DisassociateIpGroupsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.DisassociateIpGroupsResponse.ReadOnly
          ] = proxy(DisassociateIpGroups, request)
          def describeClientProperties(
              request: DescribeClientPropertiesRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly
          ] = proxy(DescribeClientProperties, request)
          def updateConnectionAliasPermission(
              request: UpdateConnectionAliasPermissionRequest
          ): IO[
            AwsError,
            zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.ReadOnly
          ] = proxy(UpdateConnectionAliasPermission, request)
          def createTags(request: CreateTagsRequest): IO[
            AwsError,
            zio.aws.workspaces.model.CreateTagsResponse.ReadOnly
          ] = proxy(CreateTags, request)
        }
      }
    }
  }
}
