package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  AwsAccount,
  Timestamp,
  WorkspaceImageErrorCode,
  WorkspaceImageName,
  Description,
  WorkspaceImageId,
  WorkspaceImageDescription
}
import scala.jdk.CollectionConverters._
final case class WorkspaceImage(
    imageId: Optional[WorkspaceImageId] = Optional.Absent,
    name: Optional[WorkspaceImageName] = Optional.Absent,
    description: Optional[WorkspaceImageDescription] = Optional.Absent,
    operatingSystem: Optional[zio.aws.workspaces.model.OperatingSystem] =
      Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkspaceImageState] =
      Optional.Absent,
    requiredTenancy: Optional[
      zio.aws.workspaces.model.WorkspaceImageRequiredTenancy
    ] = Optional.Absent,
    errorCode: Optional[WorkspaceImageErrorCode] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    ownerAccountId: Optional[AwsAccount] = Optional.Absent,
    updates: Optional[zio.aws.workspaces.model.UpdateResult] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceImage = {
    import WorkspaceImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceImage
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        name.map(value => WorkspaceImageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkspaceImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(operatingSystem.map(value => value.buildAwsValue()))(
        _.operatingSystem
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(requiredTenancy.map(value => value.unwrap))(
        _.requiredTenancy
      )
      .optionallyWith(
        errorCode.map(value =>
          WorkspaceImageErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        ownerAccountId.map(value => AwsAccount.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(updates.map(value => value.buildAwsValue()))(_.updates)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceImage.ReadOnly =
    zio.aws.workspaces.model.WorkspaceImage.wrap(buildAwsValue())
}
object WorkspaceImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceImage =
      zio.aws.workspaces.model.WorkspaceImage(
        imageId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        operatingSystem.map(value => value.asEditable),
        state.map(value => value),
        requiredTenancy.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        created.map(value => value),
        ownerAccountId.map(value => value),
        updates.map(value => value.asEditable)
      )
    def imageId: Optional[WorkspaceImageId]
    def name: Optional[WorkspaceImageName]
    def description: Optional[WorkspaceImageDescription]
    def operatingSystem
        : Optional[zio.aws.workspaces.model.OperatingSystem.ReadOnly]
    def state: Optional[zio.aws.workspaces.model.WorkspaceImageState]
    def requiredTenancy
        : Optional[zio.aws.workspaces.model.WorkspaceImageRequiredTenancy]
    def errorCode: Optional[WorkspaceImageErrorCode]
    def errorMessage: Optional[Description]
    def created: Optional[Timestamp]
    def ownerAccountId: Optional[AwsAccount]
    def updates: Optional[zio.aws.workspaces.model.UpdateResult.ReadOnly]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getName: ZIO[Any, AwsError, WorkspaceImageName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkspaceImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingSystem: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.OperatingSystem.ReadOnly
    ] = AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceImageState] =
      AwsError.unwrapOptionField("state", state)
    def getRequiredTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceImageRequiredTenancy
    ] = AwsError.unwrapOptionField("requiredTenancy", requiredTenancy)
    def getErrorCode: ZIO[Any, AwsError, WorkspaceImageErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getOwnerAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getUpdates
        : ZIO[Any, AwsError, zio.aws.workspaces.model.UpdateResult.ReadOnly] =
      AwsError.unwrapOptionField("updates", updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ) extends zio.aws.workspaces.model.WorkspaceImage.ReadOnly {
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val name: Optional[WorkspaceImageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceImageName(value)
      )
    override val description: Optional[WorkspaceImageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkspaceImageDescription(value)
        )
    override val operatingSystem
        : Optional[zio.aws.workspaces.model.OperatingSystem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.workspaces.model.OperatingSystem.wrap(value))
    override val state: Optional[zio.aws.workspaces.model.WorkspaceImageState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.WorkspaceImageState.wrap(value))
    override val requiredTenancy
        : Optional[zio.aws.workspaces.model.WorkspaceImageRequiredTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredTenancy())
        .map(value =>
          zio.aws.workspaces.model.WorkspaceImageRequiredTenancy.wrap(value)
        )
    override val errorCode: Optional[WorkspaceImageErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkspaceImageErrorCode(value)
        )
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val ownerAccountId: Optional[AwsAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
    override val updates
        : Optional[zio.aws.workspaces.model.UpdateResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updates())
        .map(value => zio.aws.workspaces.model.UpdateResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ): zio.aws.workspaces.model.WorkspaceImage.ReadOnly = new Wrapper(impl)
}
