package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{UpdateDescription, BooleanObject}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResult(
    updateAvailable: Optional[BooleanObject] = Optional.Absent,
    description: Optional[UpdateDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateResult = {
    import UpdateResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateResult
      .builder()
      .optionallyWith(updateAvailable.map(value => value: java.lang.Boolean))(
        _.updateAvailable
      )
      .optionallyWith(
        description.map(value =>
          UpdateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.UpdateResult.ReadOnly =
    zio.aws.workspaces.model.UpdateResult.wrap(buildAwsValue())
}
object UpdateResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UpdateResult =
      zio.aws.workspaces.model.UpdateResult(
        updateAvailable.map(value => value),
        description.map(value => value)
      )
    def updateAvailable: Optional[BooleanObject]
    def description: Optional[UpdateDescription]
    def getUpdateAvailable: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("updateAvailable", updateAvailable)
    def getDescription: ZIO[Any, AwsError, UpdateDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateResult
  ) extends zio.aws.workspaces.model.UpdateResult.ReadOnly {
    override val updateAvailable: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateAvailable())
        .map(value => value: BooleanObject)
    override val description: Optional[UpdateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.workspaces.model.primitives.UpdateDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateResult
  ): zio.aws.workspaces.model.UpdateResult.ReadOnly = new Wrapper(impl)
}
