package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait Tenancy {
  def unwrap: software.amazon.awssdk.services.workspaces.model.Tenancy
}
object Tenancy {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.Tenancy
  ): zio.aws.workspaces.model.Tenancy = value match {
    case software.amazon.awssdk.services.workspaces.model.Tenancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.Tenancy.DEDICATED =>
      val r = DEDICATED
      r
    case software.amazon.awssdk.services.workspaces.model.Tenancy.SHARED =>
      val r = SHARED
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.Tenancy {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Tenancy =
      software.amazon.awssdk.services.workspaces.model.Tenancy.UNKNOWN_TO_SDK_VERSION
  }
  case object DEDICATED extends zio.aws.workspaces.model.Tenancy {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Tenancy =
      software.amazon.awssdk.services.workspaces.model.Tenancy.DEDICATED
  }
  case object SHARED extends zio.aws.workspaces.model.Tenancy {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Tenancy =
      software.amazon.awssdk.services.workspaces.model.Tenancy.SHARED
  }
}
