package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  ManagementCidrRangeMaxResults,
  ManagementCidrRangeConstraint
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAvailableManagementCidrRangesRequest(
    managementCidrRangeConstraint: ManagementCidrRangeConstraint,
    maxResults: Optional[ManagementCidrRangeMaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest = {
    import ListAvailableManagementCidrRangesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest
      .builder()
      .managementCidrRangeConstraint(
        ManagementCidrRangeConstraint.unwrap(
          managementCidrRangeConstraint
        ): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          ManagementCidrRangeMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest.ReadOnly =
    zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest
      .wrap(buildAwsValue())
}
object ListAvailableManagementCidrRangesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest =
      zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest(
        managementCidrRangeConstraint,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def managementCidrRangeConstraint: ManagementCidrRangeConstraint
    def maxResults: Optional[ManagementCidrRangeMaxResults]
    def nextToken: Optional[PaginationToken]
    def getManagementCidrRangeConstraint
        : ZIO[Any, Nothing, ManagementCidrRangeConstraint] =
      ZIO.succeed(managementCidrRangeConstraint)
    def getMaxResults: ZIO[Any, AwsError, ManagementCidrRangeMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest
  ) extends zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest.ReadOnly {
    override val managementCidrRangeConstraint: ManagementCidrRangeConstraint =
      zio.aws.workspaces.model.primitives
        .ManagementCidrRangeConstraint(impl.managementCidrRangeConstraint())
    override val maxResults: Optional[ManagementCidrRangeMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.workspaces.model.primitives
            .ManagementCidrRangeMaxResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest
  ): zio.aws.workspaces.model.ListAvailableManagementCidrRangesRequest.ReadOnly =
    new Wrapper(impl)
}
