package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{DirectoryId, AmazonUuid}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectClientAddInRequest(
    addInId: AmazonUuid,
    resourceId: DirectoryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest = {
    import DeleteConnectClientAddInRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest
      .builder()
      .addInId(AmazonUuid.unwrap(addInId): java.lang.String)
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeleteConnectClientAddInRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteConnectClientAddInRequest
      .wrap(buildAwsValue())
}
object DeleteConnectClientAddInRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteConnectClientAddInRequest =
      zio.aws.workspaces.model
        .DeleteConnectClientAddInRequest(addInId, resourceId)
    def addInId: AmazonUuid
    def resourceId: DirectoryId
    def getAddInId: ZIO[Any, Nothing, AmazonUuid] = ZIO.succeed(addInId)
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest
  ) extends zio.aws.workspaces.model.DeleteConnectClientAddInRequest.ReadOnly {
    override val addInId: AmazonUuid =
      zio.aws.workspaces.model.primitives.AmazonUuid(impl.addInId())
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest
  ): zio.aws.workspaces.model.DeleteConnectClientAddInRequest.ReadOnly =
    new Wrapper(impl)
}
