package zio.aws.workspaces.model
import scala.jdk.CollectionConverters._
sealed trait WorkspaceImageIngestionProcess {
  def unwrap: software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess
}
object WorkspaceImageIngestionProcess {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess
  ): zio.aws.workspaces.model.WorkspaceImageIngestionProcess = value match {
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_REGULAR =>
      val r = BYOL_REGULAR
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_GRAPHICS =>
      val r = BYOL_GRAPHICS
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_GRAPHICSPRO =>
      val r = BYOL_GRAPHICSPRO
      r
    case software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_REGULAR_WSP =>
      val r = BYOL_REGULAR_WSP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.WorkspaceImageIngestionProcess {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.UNKNOWN_TO_SDK_VERSION
  }
  case object BYOL_REGULAR
      extends zio.aws.workspaces.model.WorkspaceImageIngestionProcess {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_REGULAR
  }
  case object BYOL_GRAPHICS
      extends zio.aws.workspaces.model.WorkspaceImageIngestionProcess {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_GRAPHICS
  }
  case object BYOL_GRAPHICSPRO
      extends zio.aws.workspaces.model.WorkspaceImageIngestionProcess {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_GRAPHICSPRO
  }
  case object BYOL_REGULAR_WSP
      extends zio.aws.workspaces.model.WorkspaceImageIngestionProcess {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess =
      software.amazon.awssdk.services.workspaces.model.WorkspaceImageIngestionProcess.BYOL_REGULAR_WSP
  }
}
