package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpGroupDesc, IpGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIpGroupRequest(
    groupName: IpGroupName,
    groupDesc: Optional[IpGroupDesc] = Optional.Absent,
    userRules: Optional[Iterable[zio.aws.workspaces.model.IpRuleItem]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest = {
    import CreateIpGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest
      .builder()
      .groupName(IpGroupName.unwrap(groupName): java.lang.String)
      .optionallyWith(
        groupDesc.map(value => IpGroupDesc.unwrap(value): java.lang.String)
      )(_.groupDesc)
      .optionallyWith(
        userRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userRules)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CreateIpGroupRequest.ReadOnly =
    zio.aws.workspaces.model.CreateIpGroupRequest.wrap(buildAwsValue())
}
object CreateIpGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateIpGroupRequest =
      zio.aws.workspaces.model.CreateIpGroupRequest(
        groupName,
        groupDesc.map(value => value),
        userRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupName: IpGroupName
    def groupDesc: Optional[IpGroupDesc]
    def userRules: Optional[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]]
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getGroupName: ZIO[Any, Nothing, IpGroupName] = ZIO.succeed(groupName)
    def getGroupDesc: ZIO[Any, AwsError, IpGroupDesc] =
      AwsError.unwrapOptionField("groupDesc", groupDesc)
    def getUserRules: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.IpRuleItem.ReadOnly
    ]] = AwsError.unwrapOptionField("userRules", userRules)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest
  ) extends zio.aws.workspaces.model.CreateIpGroupRequest.ReadOnly {
    override val groupName: IpGroupName =
      zio.aws.workspaces.model.primitives.IpGroupName(impl.groupName())
    override val groupDesc: Optional[IpGroupDesc] = zio.aws.core.internal
      .optionalFromNullable(impl.groupDesc())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupDesc(value))
    override val userRules
        : Optional[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.IpRuleItem.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest
  ): zio.aws.workspaces.model.CreateIpGroupRequest.ReadOnly = new Wrapper(impl)
}
