package zio.aws.workmailmessageflow.model
import zio.ZIO
import zio.aws.workmailmessageflow.model.primitives.MessageIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutRawMessageContentRequest(
    messageId: MessageIdType,
    content: zio.aws.workmailmessageflow.model.RawMessageContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest = {
    import PutRawMessageContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest
      .builder()
      .messageId(MessageIdType.unwrap(messageId): java.lang.String)
      .content(content.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workmailmessageflow.model.PutRawMessageContentRequest.ReadOnly =
    zio.aws.workmailmessageflow.model.PutRawMessageContentRequest
      .wrap(buildAwsValue())
}
object PutRawMessageContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workmailmessageflow.model.PutRawMessageContentRequest =
      zio.aws.workmailmessageflow.model
        .PutRawMessageContentRequest(messageId, content.asEditable)
    def messageId: MessageIdType
    def content: zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly
    def getMessageId: ZIO[Any, Nothing, MessageIdType] = ZIO.succeed(messageId)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly
    ] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest
  ) extends zio.aws.workmailmessageflow.model.PutRawMessageContentRequest.ReadOnly {
    override val messageId: MessageIdType =
      zio.aws.workmailmessageflow.model.primitives
        .MessageIdType(impl.messageId())
    override val content
        : zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly =
      zio.aws.workmailmessageflow.model.RawMessageContent.wrap(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest
  ): zio.aws.workmailmessageflow.model.PutRawMessageContentRequest.ReadOnly =
    new Wrapper(impl)
}
