package zio.aws.workmailmessageflow
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.workmailmessageflow.model.{
  PutRawMessageContentResponse,
  PutRawMessageContentRequest,
  GetRawMessageContentResponse,
  GetRawMessageContentRequest
}
import zio.aws.workmailmessageflow.model.PutRawMessageContentResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.workmailmessageflow.{
  WorkMailMessageFlowAsyncClientBuilder,
  WorkMailMessageFlowAsyncClient
}
import scala.jdk.CollectionConverters.*
trait WorkMailMessageFlow extends AspectSupport[WorkMailMessageFlow] {
  val api: WorkMailMessageFlowAsyncClient
  def getRawMessageContent(
      request: zio.aws.workmailmessageflow.model.GetRawMessageContentRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.ReadOnly,
    Byte
  ]]
  def putRawMessageContent(
      request: zio.aws.workmailmessageflow.model.PutRawMessageContentRequest
  ): IO[AwsError, ReadOnly]
}
object WorkMailMessageFlow {
  val live: ZLayer[AwsConfig, java.lang.Throwable, WorkMailMessageFlow] =
    customized(identity)
  def customized(
      customization: WorkMailMessageFlowAsyncClientBuilder => WorkMailMessageFlowAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, WorkMailMessageFlow] = managed(
    customization
  ).toLayer
  def managed(
      customization: WorkMailMessageFlowAsyncClientBuilder => WorkMailMessageFlowAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, WorkMailMessageFlow] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = WorkMailMessageFlowAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        WorkMailMessageFlowAsyncClient,
        WorkMailMessageFlowAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        WorkMailMessageFlowAsyncClient,
        WorkMailMessageFlowAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new WorkMailMessageFlowImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class WorkMailMessageFlowImpl[R](
      override val api: WorkMailMessageFlowAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends WorkMailMessageFlow
      with AwsServiceBase[R] {
    override val serviceName: String = "WorkMailMessageFlow"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): WorkMailMessageFlowImpl[R1] =
      new WorkMailMessageFlowImpl(api, newAspect, r)
    def getRawMessageContent(
        request: zio.aws.workmailmessageflow.model.GetRawMessageContentRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      GetRawMessageContentRequest,
      GetRawMessageContentResponse
    ](
      "getRawMessageContent",
      api.getRawMessageContent[Task[
        StreamingOutputResult[R, GetRawMessageContentResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def putRawMessageContent(
        request: zio.aws.workmailmessageflow.model.PutRawMessageContentRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      PutRawMessageContentRequest,
      PutRawMessageContentResponse
    ]("putRawMessageContent", api.putRawMessageContent)(request.buildAwsValue())
      .map(zio.aws.workmailmessageflow.model.PutRawMessageContentResponse.wrap)
      .provideEnvironment(r)
  }
  def getRawMessageContent(
      request: zio.aws.workmailmessageflow.model.GetRawMessageContentRequest
  ): ZIO[
    zio.aws.workmailmessageflow.WorkMailMessageFlow,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.ReadOnly,
      Byte
    ]
  ] = ZIO.serviceWithZIO(_.getRawMessageContent(request))
  def putRawMessageContent(
      request: zio.aws.workmailmessageflow.model.PutRawMessageContentRequest
  ): ZIO[zio.aws.workmailmessageflow.WorkMailMessageFlow, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putRawMessageContent(request))
}
