package zio.aws.workmailmessageflow.model
import zio.ZIO
import zio.aws.workmailmessageflow.model.primitives.MessageIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRawMessageContentRequest(messageId: MessageIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest = {
    import GetRawMessageContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest
      .builder()
      .messageId(MessageIdType.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workmailmessageflow.model.GetRawMessageContentRequest.ReadOnly =
    zio.aws.workmailmessageflow.model.GetRawMessageContentRequest
      .wrap(buildAwsValue())
}
object GetRawMessageContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workmailmessageflow.model.GetRawMessageContentRequest =
      zio.aws.workmailmessageflow.model.GetRawMessageContentRequest(messageId)
    def messageId: MessageIdType
    def getMessageId: ZIO[Any, Nothing, MessageIdType] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest
  ) extends zio.aws.workmailmessageflow.model.GetRawMessageContentRequest.ReadOnly {
    override val messageId: MessageIdType =
      zio.aws.workmailmessageflow.model.primitives
        .MessageIdType(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest
  ): zio.aws.workmailmessageflow.model.GetRawMessageContentRequest.ReadOnly =
    new Wrapper(impl)
}
