package zio.aws.workmailmessageflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RawMessageContent(
    s3Reference: zio.aws.workmailmessageflow.model.S3Reference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent = {
    import RawMessageContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent
      .builder()
      .s3Reference(s3Reference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly =
    zio.aws.workmailmessageflow.model.RawMessageContent.wrap(buildAwsValue())
}
object RawMessageContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workmailmessageflow.model.RawMessageContent =
      zio.aws.workmailmessageflow.model
        .RawMessageContent(s3Reference.asEditable)
    def s3Reference: zio.aws.workmailmessageflow.model.S3Reference.ReadOnly
    def getS3Reference: ZIO[
      Any,
      Nothing,
      zio.aws.workmailmessageflow.model.S3Reference.ReadOnly
    ] = ZIO.succeed(s3Reference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent
  ) extends zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly {
    override val s3Reference
        : zio.aws.workmailmessageflow.model.S3Reference.ReadOnly =
      zio.aws.workmailmessageflow.model.S3Reference.wrap(impl.s3Reference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.RawMessageContent
  ): zio.aws.workmailmessageflow.model.RawMessageContent.ReadOnly = new Wrapper(
    impl
  )
}
