package zio.aws.workmailmessageflow.model
import zio.ZIO
import zio.aws.workmailmessageflow.model.primitives.{
  S3VersionType,
  S3KeyIdType,
  S3BucketIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Reference(
    bucket: S3BucketIdType,
    key: S3KeyIdType,
    objectVersion: Option[S3VersionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workmailmessageflow.model.S3Reference = {
    import S3Reference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workmailmessageflow.model.S3Reference
      .builder()
      .bucket(S3BucketIdType.unwrap(bucket): java.lang.String)
      .key(S3KeyIdType.unwrap(key): java.lang.String)
      .optionallyWith(
        objectVersion.map(value =>
          S3VersionType.unwrap(value): java.lang.String
        )
      )(_.objectVersion)
      .build()
  }
  def asReadOnly: zio.aws.workmailmessageflow.model.S3Reference.ReadOnly =
    zio.aws.workmailmessageflow.model.S3Reference.wrap(buildAwsValue())
}
object S3Reference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workmailmessageflow.model.S3Reference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workmailmessageflow.model.S3Reference =
      zio.aws.workmailmessageflow.model
        .S3Reference(bucket, key, objectVersion.map(value => value))
    def bucket: S3BucketIdType
    def key: S3KeyIdType
    def objectVersion: Option[S3VersionType]
    def getBucket: ZIO[Any, Nothing, S3BucketIdType] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3KeyIdType] = ZIO.succeed(key)
    def getObjectVersion: ZIO[Any, AwsError, S3VersionType] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.S3Reference
  ) extends zio.aws.workmailmessageflow.model.S3Reference.ReadOnly {
    override val bucket: S3BucketIdType =
      zio.aws.workmailmessageflow.model.primitives.S3BucketIdType(impl.bucket())
    override val key: S3KeyIdType =
      zio.aws.workmailmessageflow.model.primitives.S3KeyIdType(impl.key())
    override val objectVersion: Option[S3VersionType] = scala
      .Option(impl.objectVersion())
      .map(value =>
        zio.aws.workmailmessageflow.model.primitives.S3VersionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workmailmessageflow.model.S3Reference
  ): zio.aws.workmailmessageflow.model.S3Reference.ReadOnly = new Wrapper(impl)
}
