package zio.aws.workmailmessageflow
import zio.aws.workmailmessageflow.model.PutRawMessageContentResponse.ReadOnly
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.workmailmessageflow.model.{
  PutRawMessageContentRequest,
  GetRawMessageContentRequest
}
import zio.test.mock.{Proxy, Mock}
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowAsyncClient
object WorkMailMessageFlowMock extends Mock[WorkMailMessageFlow] {
  object GetRawMessageContent
      extends Effect[GetRawMessageContentRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.ReadOnly,
        Byte
      ]]
  object PutRawMessageContent
      extends Effect[PutRawMessageContentRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, WorkMailMessageFlow] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new WorkMailMessageFlow {
          val api: WorkMailMessageFlowAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : WorkMailMessageFlow = this
          def getRawMessageContent(
              request: GetRawMessageContentRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.workmailmessageflow.model.GetRawMessageContentResponse.ReadOnly,
            Byte
          ]] = proxy(GetRawMessageContent, request)
          def putRawMessageContent(
              request: PutRawMessageContentRequest
          ): IO[AwsError, ReadOnly] = proxy(PutRawMessageContent, request)
        }
      }
    }
    .toLayer
}
