package zio.aws.workdocs
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  HeaderNameType,
  HeaderValueType,
  UrlType,
  SharedLabel,
  SearchLabel,
  SearchAncestorId,
  CustomMetadataValueType,
  CustomMetadataKeyType
}
import zio.aws.workdocs.model.primitives.PositiveIntegerType.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ActivityNamesFilterType extends Subtype[String]
    type ActivityNamesFilterType =
      zio.aws.workdocs.model.primitives.ActivityNamesFilterType.Type
    object AuthenticationHeaderType extends Subtype[String]
    type AuthenticationHeaderType =
      zio.aws.workdocs.model.primitives.AuthenticationHeaderType.Type
    object BooleanType extends Subtype[Boolean]
    type BooleanType = zio.aws.workdocs.model.primitives.BooleanType.Type
    object CommentIdType extends Subtype[String]
    type CommentIdType = zio.aws.workdocs.model.primitives.CommentIdType.Type
    object CommentTextType extends Subtype[String]
    type CommentTextType =
      zio.aws.workdocs.model.primitives.CommentTextType.Type
    object CustomMetadataKeyType extends Subtype[String]
    type CustomMetadataKeyType =
      zio.aws.workdocs.model.primitives.CustomMetadataKeyType.Type
    object CustomMetadataValueType extends Subtype[String]
    type CustomMetadataValueType =
      zio.aws.workdocs.model.primitives.CustomMetadataValueType.Type
    object DocumentContentType extends Subtype[String]
    type DocumentContentType =
      zio.aws.workdocs.model.primitives.DocumentContentType.Type
    object DocumentVersionIdType extends Subtype[String]
    type DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType.Type
    object EmailAddressType extends Subtype[String]
    type EmailAddressType =
      zio.aws.workdocs.model.primitives.EmailAddressType.Type
    object FieldNamesType extends Subtype[String]
    type FieldNamesType = zio.aws.workdocs.model.primitives.FieldNamesType.Type
    object GroupNameType extends Subtype[String]
    type GroupNameType = zio.aws.workdocs.model.primitives.GroupNameType.Type
    object HashType extends Subtype[String]
    type HashType = zio.aws.workdocs.model.primitives.HashType.Type
    object HeaderNameType extends Subtype[String]
    type HeaderNameType = zio.aws.workdocs.model.primitives.HeaderNameType.Type
    object HeaderValueType extends Subtype[String]
    type HeaderValueType =
      zio.aws.workdocs.model.primitives.HeaderValueType.Type
    object IdType extends Subtype[String]
    type IdType = zio.aws.workdocs.model.primitives.IdType.Type
    object LimitType extends Subtype[Int]
    type LimitType = zio.aws.workdocs.model.primitives.LimitType.Type
    object LongType extends Subtype[Long]
    type LongType = zio.aws.workdocs.model.primitives.LongType.Type
    object MarkerType extends Subtype[String]
    type MarkerType = zio.aws.workdocs.model.primitives.MarkerType.Type
    object MessageType extends Subtype[String]
    type MessageType = zio.aws.workdocs.model.primitives.MessageType.Type
    object NextMarkerType extends Subtype[String]
    type NextMarkerType = zio.aws.workdocs.model.primitives.NextMarkerType.Type
    object PageMarkerType extends Subtype[String]
    type PageMarkerType = zio.aws.workdocs.model.primitives.PageMarkerType.Type
    object PasswordType extends Subtype[String]
    type PasswordType = zio.aws.workdocs.model.primitives.PasswordType.Type
    object PositiveIntegerType extends Subtype[Int]
    type PositiveIntegerType =
      zio.aws.workdocs.model.primitives.PositiveIntegerType.Type
    object PositiveSizeType extends Subtype[Long]
    type PositiveSizeType =
      zio.aws.workdocs.model.primitives.PositiveSizeType.Type
    object ResourceIdType extends Subtype[String]
    type ResourceIdType = zio.aws.workdocs.model.primitives.ResourceIdType.Type
    object ResourceNameType extends Subtype[String]
    type ResourceNameType =
      zio.aws.workdocs.model.primitives.ResourceNameType.Type
    object ResponseItemWebUrl extends Subtype[String]
    type ResponseItemWebUrl =
      zio.aws.workdocs.model.primitives.ResponseItemWebUrl.Type
    object SearchAncestorId extends Subtype[String]
    type SearchAncestorId =
      zio.aws.workdocs.model.primitives.SearchAncestorId.Type
    object SearchLabel extends Subtype[String]
    type SearchLabel = zio.aws.workdocs.model.primitives.SearchLabel.Type
    object SearchMarkerType extends Subtype[String]
    type SearchMarkerType =
      zio.aws.workdocs.model.primitives.SearchMarkerType.Type
    object SearchQueryType extends Subtype[String]
    type SearchQueryType =
      zio.aws.workdocs.model.primitives.SearchQueryType.Type
    object SearchResultsLimitType extends Subtype[Int]
    type SearchResultsLimitType =
      zio.aws.workdocs.model.primitives.SearchResultsLimitType.Type
    object SharedLabel extends Subtype[String]
    type SharedLabel = zio.aws.workdocs.model.primitives.SharedLabel.Type
    object SizeType extends Subtype[Long]
    type SizeType = zio.aws.workdocs.model.primitives.SizeType.Type
    object SubscriptionEndPointType extends Subtype[String]
    type SubscriptionEndPointType =
      zio.aws.workdocs.model.primitives.SubscriptionEndPointType.Type
    object TimeZoneIdType extends Subtype[String]
    type TimeZoneIdType = zio.aws.workdocs.model.primitives.TimeZoneIdType.Type
    object TimestampType extends Subtype[Instant]
    type TimestampType = zio.aws.workdocs.model.primitives.TimestampType.Type
    object UrlType extends Subtype[String]
    type UrlType = zio.aws.workdocs.model.primitives.UrlType.Type
    object UserAttributeValueType extends Subtype[String]
    type UserAttributeValueType =
      zio.aws.workdocs.model.primitives.UserAttributeValueType.Type
    object UserIdsType extends Subtype[String]
    type UserIdsType = zio.aws.workdocs.model.primitives.UserIdsType.Type
    object UsernameType extends Subtype[String]
    type UsernameType = zio.aws.workdocs.model.primitives.UsernameType.Type
  }
  type AdditionalResponseFieldsList =
    List[zio.aws.workdocs.model.AdditionalResponseFieldType]
  type CommentList = List[zio.aws.workdocs.model.Comment]
  type CustomMetadataKeyList = List[CustomMetadataKeyType]
  type CustomMetadataMap = Map[CustomMetadataKeyType, CustomMetadataValueType]
  type DocumentMetadataList = List[zio.aws.workdocs.model.DocumentMetadata]
  type DocumentSourceUrlMap =
    Map[zio.aws.workdocs.model.DocumentSourceType, UrlType]
  type DocumentThumbnailUrlMap =
    Map[zio.aws.workdocs.model.DocumentThumbnailType, UrlType]
  type DocumentVersionMetadataList =
    List[zio.aws.workdocs.model.DocumentVersionMetadata]
  type FolderMetadataList = List[zio.aws.workdocs.model.FolderMetadata]
  type GroupMetadataList = List[zio.aws.workdocs.model.GroupMetadata]
  type OrganizationUserList = List[zio.aws.workdocs.model.User]
  type PermissionInfoList = List[zio.aws.workdocs.model.PermissionInfo]
  type PrincipalList = List[zio.aws.workdocs.model.Principal]
  type ResourcePathComponentList =
    List[zio.aws.workdocs.model.ResourcePathComponent]
  type ResponseItemsList = List[zio.aws.workdocs.model.ResponseItem]
  type SearchAncestorIdList = List[SearchAncestorId]
  type SearchCollectionTypeList =
    List[zio.aws.workdocs.model.SearchCollectionType]
  type SearchContentCategoryTypeList =
    List[zio.aws.workdocs.model.ContentCategoryType]
  type SearchLabelList = List[SearchLabel]
  type SearchPrincipalRoleList = List[zio.aws.workdocs.model.PrincipalRoleType]
  type SearchPrincipalTypeList =
    List[zio.aws.workdocs.model.SearchPrincipalType]
  type SearchQueryScopeTypeList =
    List[zio.aws.workdocs.model.SearchQueryScopeType]
  type SearchResourceTypeList = List[zio.aws.workdocs.model.SearchResourceType]
  type SearchResultSortList = List[zio.aws.workdocs.model.SearchSortResult]
  type SharePrincipalList = List[zio.aws.workdocs.model.SharePrincipal]
  type ShareResultsList = List[zio.aws.workdocs.model.ShareResult]
  type SharedLabels = List[SharedLabel]
  type SignedHeaderMap = Map[HeaderNameType, HeaderValueType]
  type SubscriptionList = List[zio.aws.workdocs.model.Subscription]
  type TextLocaleTypeList = List[zio.aws.workdocs.model.LanguageCodeType]
  type UserActivities = List[zio.aws.workdocs.model.Activity]
  type UserMetadataList = List[zio.aws.workdocs.model.UserMetadata]
}
