package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.MarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeGroupsResponse(
    groups: Optional[Iterable[zio.aws.workdocs.model.GroupMetadata]] =
      Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse = {
    import DescribeGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeGroupsResponse.wrap(buildAwsValue())
}
object DescribeGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeGroupsResponse =
      zio.aws.workdocs.model.DescribeGroupsResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def groups: Optional[List[zio.aws.workdocs.model.GroupMetadata.ReadOnly]]
    def marker: Optional[MarkerType]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.GroupMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse
  ) extends zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly {
    override val groups
        : Optional[List[zio.aws.workdocs.model.GroupMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.GroupMetadata.wrap(item)
          }.toList
        )
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse
  ): zio.aws.workdocs.model.DescribeGroupsResponse.ReadOnly = new Wrapper(impl)
}
