package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  IdType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class RemoveResourcePermissionRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    resourceId: ResourceIdType,
    principalId: IdType,
    principalType: Optional[zio.aws.workdocs.model.PrincipalType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest = {
    import RemoveResourcePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .principalId(IdType.unwrap(principalId): java.lang.String)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.RemoveResourcePermissionRequest.ReadOnly =
    zio.aws.workdocs.model.RemoveResourcePermissionRequest.wrap(buildAwsValue())
}
object RemoveResourcePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.RemoveResourcePermissionRequest =
      zio.aws.workdocs.model.RemoveResourcePermissionRequest(
        authenticationToken.map(value => value),
        resourceId,
        principalId,
        principalType.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def principalId: IdType
    def principalType: Optional[zio.aws.workdocs.model.PrincipalType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getPrincipalId: ZIO[Any, Nothing, IdType] = ZIO.succeed(principalId)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.workdocs.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest
  ) extends zio.aws.workdocs.model.RemoveResourcePermissionRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val principalId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.principalId())
    override val principalType: Optional[zio.aws.workdocs.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.workdocs.model.PrincipalType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest
  ): zio.aws.workdocs.model.RemoveResourcePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
