package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  SharedLabel,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class DeleteLabelsRequest(
    resourceId: ResourceIdType,
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    labels: Optional[Iterable[SharedLabel]] = Optional.Absent,
    deleteAll: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest = {
    import DeleteLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest
      .builder()
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SharedLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        deleteAll.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.deleteAll)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteLabelsRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteLabelsRequest.wrap(buildAwsValue())
}
object DeleteLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteLabelsRequest =
      zio.aws.workdocs.model.DeleteLabelsRequest(
        resourceId,
        authenticationToken.map(value => value),
        labels.map(value => value),
        deleteAll.map(value => value)
      )
    def resourceId: ResourceIdType
    def authenticationToken: Optional[AuthenticationHeaderType]
    def labels: Optional[List[SharedLabel]]
    def deleteAll: Optional[BooleanType]
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getLabels: ZIO[Any, AwsError, List[SharedLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getDeleteAll: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("deleteAll", deleteAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest
  ) extends zio.aws.workdocs.model.DeleteLabelsRequest.ReadOnly {
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val labels: Optional[List[SharedLabel]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SharedLabel(item)
        }.toList
      )
    override val deleteAll: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAll())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest
  ): zio.aws.workdocs.model.DeleteLabelsRequest.ReadOnly = new Wrapper(impl)
}
