package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.PositiveSizeType
import scala.jdk.CollectionConverters.*
final case class StorageRuleType(
    storageAllocatedInBytes: Optional[PositiveSizeType] = Optional.Absent,
    storageType: Optional[zio.aws.workdocs.model.StorageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.StorageRuleType = {
    import StorageRuleType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.StorageRuleType
      .builder()
      .optionallyWith(
        storageAllocatedInBytes.map(value =>
          PositiveSizeType.unwrap(value): java.lang.Long
        )
      )(_.storageAllocatedInBytes)
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.StorageRuleType.ReadOnly =
    zio.aws.workdocs.model.StorageRuleType.wrap(buildAwsValue())
}
object StorageRuleType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.StorageRuleType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.StorageRuleType =
      zio.aws.workdocs.model.StorageRuleType(
        storageAllocatedInBytes.map(value => value),
        storageType.map(value => value)
      )
    def storageAllocatedInBytes: Optional[PositiveSizeType]
    def storageType: Optional[zio.aws.workdocs.model.StorageType]
    def getStorageAllocatedInBytes: ZIO[Any, AwsError, PositiveSizeType] =
      AwsError.unwrapOptionField(
        "storageAllocatedInBytes",
        storageAllocatedInBytes
      )
    def getStorageType: ZIO[Any, AwsError, zio.aws.workdocs.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.StorageRuleType
  ) extends zio.aws.workdocs.model.StorageRuleType.ReadOnly {
    override val storageAllocatedInBytes: Optional[PositiveSizeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageAllocatedInBytes())
        .map(value => zio.aws.workdocs.model.primitives.PositiveSizeType(value))
    override val storageType: Optional[zio.aws.workdocs.model.StorageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageType())
        .map(value => zio.aws.workdocs.model.StorageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.StorageRuleType
  ): zio.aws.workdocs.model.StorageRuleType.ReadOnly = new Wrapper(impl)
}
