package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  SearchQueryType,
  NextMarkerType,
  IdType,
  SearchResultsLimitType,
  AuthenticationHeaderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchResourcesRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    queryText: Optional[SearchQueryType] = Optional.Absent,
    queryScopes: Optional[
      Iterable[zio.aws.workdocs.model.SearchQueryScopeType]
    ] = Optional.Absent,
    organizationId: Optional[IdType] = Optional.Absent,
    additionalResponseFields: Optional[
      Iterable[zio.aws.workdocs.model.AdditionalResponseFieldType]
    ] = Optional.Absent,
    filters: Optional[zio.aws.workdocs.model.Filters] = Optional.Absent,
    orderBy: Optional[Iterable[zio.aws.workdocs.model.SearchSortResult]] =
      Optional.Absent,
    limit: Optional[SearchResultsLimitType] = Optional.Absent,
    marker: Optional[NextMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest = {
    import SearchResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        queryText.map(value => SearchQueryType.unwrap(value): java.lang.String)
      )(_.queryText)
      .optionallyWith(
        queryScopes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.queryScopesWithStrings)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        additionalResponseFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.additionalResponseFieldsWithStrings)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        orderBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderBy)
      .optionallyWith(
        limit.map(value => SearchResultsLimitType.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        marker.map(value => NextMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.SearchResourcesRequest.ReadOnly =
    zio.aws.workdocs.model.SearchResourcesRequest.wrap(buildAwsValue())
}
object SearchResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.SearchResourcesRequest =
      zio.aws.workdocs.model.SearchResourcesRequest(
        authenticationToken.map(value => value),
        queryText.map(value => value),
        queryScopes.map(value => value),
        organizationId.map(value => value),
        additionalResponseFields.map(value => value),
        filters.map(value => value.asEditable),
        orderBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def queryText: Optional[SearchQueryType]
    def queryScopes: Optional[List[zio.aws.workdocs.model.SearchQueryScopeType]]
    def organizationId: Optional[IdType]
    def additionalResponseFields
        : Optional[List[zio.aws.workdocs.model.AdditionalResponseFieldType]]
    def filters: Optional[zio.aws.workdocs.model.Filters.ReadOnly]
    def orderBy
        : Optional[List[zio.aws.workdocs.model.SearchSortResult.ReadOnly]]
    def limit: Optional[SearchResultsLimitType]
    def marker: Optional[NextMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getQueryText: ZIO[Any, AwsError, SearchQueryType] =
      AwsError.unwrapOptionField("queryText", queryText)
    def getQueryScopes: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.SearchQueryScopeType
    ]] = AwsError.unwrapOptionField("queryScopes", queryScopes)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getAdditionalResponseFields: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.AdditionalResponseFieldType
    ]] = AwsError.unwrapOptionField(
      "additionalResponseFields",
      additionalResponseFields
    )
    def getFilters
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Filters.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getOrderBy: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.SearchSortResult.ReadOnly
    ]] = AwsError.unwrapOptionField("orderBy", orderBy)
    def getLimit: ZIO[Any, AwsError, SearchResultsLimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, NextMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest
  ) extends zio.aws.workdocs.model.SearchResourcesRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val queryText: Optional[SearchQueryType] = zio.aws.core.internal
      .optionalFromNullable(impl.queryText())
      .map(value => zio.aws.workdocs.model.primitives.SearchQueryType(value))
    override val queryScopes
        : Optional[List[zio.aws.workdocs.model.SearchQueryScopeType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryScopes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.SearchQueryScopeType.wrap(item)
          }.toList
        )
    override val organizationId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val additionalResponseFields
        : Optional[List[zio.aws.workdocs.model.AdditionalResponseFieldType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalResponseFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.AdditionalResponseFieldType.wrap(item)
          }.toList
        )
    override val filters: Optional[zio.aws.workdocs.model.Filters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.workdocs.model.Filters.wrap(value))
    override val orderBy
        : Optional[List[zio.aws.workdocs.model.SearchSortResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.SearchSortResult.wrap(item)
          }.toList
        )
    override val limit: Optional[SearchResultsLimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.workdocs.model.primitives.SearchResultsLimitType(value)
      )
    override val marker: Optional[NextMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.NextMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest
  ): zio.aws.workdocs.model.SearchResourcesRequest.ReadOnly = new Wrapper(impl)
}
