package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait ResponseItemType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ResponseItemType
}
object ResponseItemType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ResponseItemType
  ): zio.aws.workdocs.model.ResponseItemType = value match {
    case software.amazon.awssdk.services.workdocs.model.ResponseItemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ResponseItemType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.workdocs.model.ResponseItemType.FOLDER =>
      val r = FOLDER
      r
    case software.amazon.awssdk.services.workdocs.model.ResponseItemType.COMMENT =>
      val r = COMMENT
      r
    case software.amazon.awssdk.services.workdocs.model.ResponseItemType.DOCUMENT_VERSION =>
      val r = DOCUMENT_VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.ResponseItemType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResponseItemType =
      software.amazon.awssdk.services.workdocs.model.ResponseItemType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT extends zio.aws.workdocs.model.ResponseItemType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResponseItemType =
      software.amazon.awssdk.services.workdocs.model.ResponseItemType.DOCUMENT
  }
  case object FOLDER extends zio.aws.workdocs.model.ResponseItemType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResponseItemType =
      software.amazon.awssdk.services.workdocs.model.ResponseItemType.FOLDER
  }
  case object COMMENT extends zio.aws.workdocs.model.ResponseItemType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResponseItemType =
      software.amazon.awssdk.services.workdocs.model.ResponseItemType.COMMENT
  }
  case object DOCUMENT_VERSION extends zio.aws.workdocs.model.ResponseItemType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResponseItemType =
      software.amazon.awssdk.services.workdocs.model.ResponseItemType.DOCUMENT_VERSION
  }
}
