package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{IdType, AuthenticationHeaderType}
import scala.jdk.CollectionConverters.*
final case class DeleteUserRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    userId: IdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteUserRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .userId(IdType.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteUserRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteUserRequest =
      zio.aws.workdocs.model
        .DeleteUserRequest(authenticationToken.map(value => value), userId)
    def authenticationToken: Optional[AuthenticationHeaderType]
    def userId: IdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getUserId: ZIO[Any, Nothing, IdType] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteUserRequest
  ) extends zio.aws.workdocs.model.DeleteUserRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val userId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteUserRequest
  ): zio.aws.workdocs.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
