package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchSortResult(
    field: Optional[zio.aws.workdocs.model.OrderByFieldType] = Optional.Absent,
    order: Optional[zio.aws.workdocs.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.SearchSortResult = {
    import SearchSortResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.SearchSortResult
      .builder()
      .optionallyWith(field.map(value => value.unwrap))(_.field)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.SearchSortResult.ReadOnly =
    zio.aws.workdocs.model.SearchSortResult.wrap(buildAwsValue())
}
object SearchSortResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.SearchSortResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.SearchSortResult =
      zio.aws.workdocs.model
        .SearchSortResult(field.map(value => value), order.map(value => value))
    def field: Optional[zio.aws.workdocs.model.OrderByFieldType]
    def order: Optional[zio.aws.workdocs.model.SortOrder]
    def getField: ZIO[Any, AwsError, zio.aws.workdocs.model.OrderByFieldType] =
      AwsError.unwrapOptionField("field", field)
    def getOrder: ZIO[Any, AwsError, zio.aws.workdocs.model.SortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.SearchSortResult
  ) extends zio.aws.workdocs.model.SearchSortResult.ReadOnly {
    override val field: Optional[zio.aws.workdocs.model.OrderByFieldType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.field())
        .map(value => zio.aws.workdocs.model.OrderByFieldType.wrap(value))
    override val order: Optional[zio.aws.workdocs.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.workdocs.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.SearchSortResult
  ): zio.aws.workdocs.model.SearchSortResult.ReadOnly = new Wrapper(impl)
}
