package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.IdType
import scala.jdk.CollectionConverters.*
final case class SearchPrincipalType(
    id: IdType,
    roles: Optional[Iterable[zio.aws.workdocs.model.PrincipalRoleType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.SearchPrincipalType = {
    import SearchPrincipalType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.SearchPrincipalType
      .builder()
      .id(IdType.unwrap(id): java.lang.String)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.rolesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.SearchPrincipalType.ReadOnly =
    zio.aws.workdocs.model.SearchPrincipalType.wrap(buildAwsValue())
}
object SearchPrincipalType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.SearchPrincipalType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.SearchPrincipalType =
      zio.aws.workdocs.model.SearchPrincipalType(id, roles.map(value => value))
    def id: IdType
    def roles: Optional[List[zio.aws.workdocs.model.PrincipalRoleType]]
    def getId: ZIO[Any, Nothing, IdType] = ZIO.succeed(id)
    def getRoles
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.PrincipalRoleType]] =
      AwsError.unwrapOptionField("roles", roles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.SearchPrincipalType
  ) extends zio.aws.workdocs.model.SearchPrincipalType.ReadOnly {
    override val id: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.id())
    override val roles
        : Optional[List[zio.aws.workdocs.model.PrincipalRoleType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.PrincipalRoleType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.SearchPrincipalType
  ): zio.aws.workdocs.model.SearchPrincipalType.ReadOnly = new Wrapper(impl)
}
