package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait PrincipalRoleType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.PrincipalRoleType
}
object PrincipalRoleType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.PrincipalRoleType
  ): zio.aws.workdocs.model.PrincipalRoleType = value match {
    case software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.VIEWER =>
      val r = VIEWER
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.CONTRIBUTOR =>
      val r = CONTRIBUTOR
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.OWNER =>
      val r = OWNER
      r
    case software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.COOWNER =>
      val r = COOWNER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.PrincipalRoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalRoleType =
      software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.UNKNOWN_TO_SDK_VERSION
  }
  case object VIEWER extends zio.aws.workdocs.model.PrincipalRoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalRoleType =
      software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.VIEWER
  }
  case object CONTRIBUTOR extends zio.aws.workdocs.model.PrincipalRoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalRoleType =
      software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.CONTRIBUTOR
  }
  case object OWNER extends zio.aws.workdocs.model.PrincipalRoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalRoleType =
      software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.OWNER
  }
  case object COOWNER extends zio.aws.workdocs.model.PrincipalRoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.PrincipalRoleType =
      software.amazon.awssdk.services.workdocs.model.PrincipalRoleType.COOWNER
  }
}
