package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  DocumentVersionIdType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class AbortDocumentVersionUploadRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest = {
    import AbortDocumentVersionUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.AbortDocumentVersionUploadRequest.ReadOnly =
    zio.aws.workdocs.model.AbortDocumentVersionUploadRequest
      .wrap(buildAwsValue())
}
object AbortDocumentVersionUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.AbortDocumentVersionUploadRequest =
      zio.aws.workdocs.model.AbortDocumentVersionUploadRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest
  ) extends zio.aws.workdocs.model.AbortDocumentVersionUploadRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest
  ): zio.aws.workdocs.model.AbortDocumentVersionUploadRequest.ReadOnly =
    new Wrapper(impl)
}
