package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class RestoreDocumentVersionsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest = {
    import RestoreDocumentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.RestoreDocumentVersionsRequest.ReadOnly =
    zio.aws.workdocs.model.RestoreDocumentVersionsRequest.wrap(buildAwsValue())
}
object RestoreDocumentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.RestoreDocumentVersionsRequest =
      zio.aws.workdocs.model.RestoreDocumentVersionsRequest(
        authenticationToken.map(value => value),
        documentId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest
  ) extends zio.aws.workdocs.model.RestoreDocumentVersionsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest
  ): zio.aws.workdocs.model.RestoreDocumentVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
