package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class RemoveAllResourcePermissionsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    resourceId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest = {
    import RemoveAllResourcePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest.ReadOnly =
    zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest
      .wrap(buildAwsValue())
}
object RemoveAllResourcePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest =
      zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest(
        authenticationToken.map(value => value),
        resourceId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest
  ) extends zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest
  ): zio.aws.workdocs.model.RemoveAllResourcePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
