package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionProtocolType {
  def unwrap
      : software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType
}
object SubscriptionProtocolType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType
  ): zio.aws.workdocs.model.SubscriptionProtocolType = value match {
    case software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.SQS =>
      val r = SQS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTPS extends zio.aws.workdocs.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.HTTPS
  }
  case object SQS extends zio.aws.workdocs.model.SubscriptionProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType =
      software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType.SQS
  }
}
