package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.LongType
import scala.jdk.CollectionConverters.*
final case class LongRangeType(
    startValue: Optional[LongType] = Optional.Absent,
    endValue: Optional[LongType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.LongRangeType = {
    import LongRangeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.LongRangeType
      .builder()
      .optionallyWith(
        startValue.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.startValue)
      .optionallyWith(
        endValue.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.endValue)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.LongRangeType.ReadOnly =
    zio.aws.workdocs.model.LongRangeType.wrap(buildAwsValue())
}
object LongRangeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.LongRangeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.LongRangeType =
      zio.aws.workdocs.model.LongRangeType(
        startValue.map(value => value),
        endValue.map(value => value)
      )
    def startValue: Optional[LongType]
    def endValue: Optional[LongType]
    def getStartValue: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("startValue", startValue)
    def getEndValue: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("endValue", endValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.LongRangeType
  ) extends zio.aws.workdocs.model.LongRangeType.ReadOnly {
    override val startValue: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.startValue())
      .map(value => zio.aws.workdocs.model.primitives.LongType(value))
    override val endValue: Optional[LongType] = zio.aws.core.internal
      .optionalFromNullable(impl.endValue())
      .map(value => zio.aws.workdocs.model.primitives.LongType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.LongRangeType
  ): zio.aws.workdocs.model.LongRangeType.ReadOnly = new Wrapper(impl)
}
