package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  DocumentVersionIdType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DeleteDocumentVersionRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    deletePriorVersions: BooleanType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest = {
    import DeleteDocumentVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .deletePriorVersions(
        BooleanType.unwrap(deletePriorVersions): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteDocumentVersionRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteDocumentVersionRequest.wrap(buildAwsValue())
}
object DeleteDocumentVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteDocumentVersionRequest =
      zio.aws.workdocs.model.DeleteDocumentVersionRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        deletePriorVersions
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def deletePriorVersions: BooleanType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getDeletePriorVersions: ZIO[Any, Nothing, BooleanType] =
      ZIO.succeed(deletePriorVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest
  ) extends zio.aws.workdocs.model.DeleteDocumentVersionRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val deletePriorVersions: BooleanType =
      zio.aws.workdocs.model.primitives.BooleanType(impl.deletePriorVersions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest
  ): zio.aws.workdocs.model.DeleteDocumentVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
