package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  SharedLabel,
  IdType,
  ResourceNameType,
  TimestampType,
  HashType,
  SizeType,
  ResourceIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FolderMetadata(
    id: Optional[ResourceIdType] = Optional.Absent,
    name: Optional[ResourceNameType] = Optional.Absent,
    creatorId: Optional[IdType] = Optional.Absent,
    parentFolderId: Optional[ResourceIdType] = Optional.Absent,
    createdTimestamp: Optional[TimestampType] = Optional.Absent,
    modifiedTimestamp: Optional[TimestampType] = Optional.Absent,
    resourceState: Optional[zio.aws.workdocs.model.ResourceStateType] =
      Optional.Absent,
    signature: Optional[HashType] = Optional.Absent,
    labels: Optional[Iterable[SharedLabel]] = Optional.Absent,
    size: Optional[SizeType] = Optional.Absent,
    latestVersionSize: Optional[SizeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.FolderMetadata = {
    import FolderMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.FolderMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        creatorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.creatorId)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .optionallyWith(
        signature.map(value => HashType.unwrap(value): java.lang.String)
      )(_.signature)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SharedLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        size.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.size)
      .optionallyWith(
        latestVersionSize.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.latestVersionSize)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.FolderMetadata.ReadOnly =
    zio.aws.workdocs.model.FolderMetadata.wrap(buildAwsValue())
}
object FolderMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.FolderMetadata =
      zio.aws.workdocs.model.FolderMetadata(
        id.map(value => value),
        name.map(value => value),
        creatorId.map(value => value),
        parentFolderId.map(value => value),
        createdTimestamp.map(value => value),
        modifiedTimestamp.map(value => value),
        resourceState.map(value => value),
        signature.map(value => value),
        labels.map(value => value),
        size.map(value => value),
        latestVersionSize.map(value => value)
      )
    def id: Optional[ResourceIdType]
    def name: Optional[ResourceNameType]
    def creatorId: Optional[IdType]
    def parentFolderId: Optional[ResourceIdType]
    def createdTimestamp: Optional[TimestampType]
    def modifiedTimestamp: Optional[TimestampType]
    def resourceState: Optional[zio.aws.workdocs.model.ResourceStateType]
    def signature: Optional[HashType]
    def labels: Optional[List[SharedLabel]]
    def size: Optional[SizeType]
    def latestVersionSize: Optional[SizeType]
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getCreatorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
    def getSignature: ZIO[Any, AwsError, HashType] =
      AwsError.unwrapOptionField("signature", signature)
    def getLabels: ZIO[Any, AwsError, List[SharedLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getSize: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("size", size)
    def getLatestVersionSize: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("latestVersionSize", latestVersionSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ) extends zio.aws.workdocs.model.FolderMetadata.ReadOnly {
    override val id: Optional[ResourceIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val name: Optional[ResourceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val creatorId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val parentFolderId: Optional[ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentFolderId())
        .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val createdTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val resourceState
        : Optional[zio.aws.workdocs.model.ResourceStateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceState())
        .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
    override val signature: Optional[HashType] = zio.aws.core.internal
      .optionalFromNullable(impl.signature())
      .map(value => zio.aws.workdocs.model.primitives.HashType(value))
    override val labels: Optional[List[SharedLabel]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SharedLabel(item)
        }.toList
      )
    override val size: Optional[SizeType] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val latestVersionSize: Optional[SizeType] = zio.aws.core.internal
      .optionalFromNullable(impl.latestVersionSize())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.FolderMetadata
  ): zio.aws.workdocs.model.FolderMetadata.ReadOnly = new Wrapper(impl)
}
