package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ResourceType
  ): zio.aws.workdocs.model.ResourceType = value match {
    case software.amazon.awssdk.services.workdocs.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceType.FOLDER =>
      val r = FOLDER
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceType.DOCUMENT =>
      val r = DOCUMENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceType =
      software.amazon.awssdk.services.workdocs.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLDER extends zio.aws.workdocs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceType =
      software.amazon.awssdk.services.workdocs.model.ResourceType.FOLDER
  }
  case object DOCUMENT extends zio.aws.workdocs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceType =
      software.amazon.awssdk.services.workdocs.model.ResourceType.DOCUMENT
  }
}
