package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.SearchMarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeActivitiesResponse(
    userActivities: Optional[Iterable[zio.aws.workdocs.model.Activity]] =
      Optional.Absent,
    marker: Optional[SearchMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse = {
    import DescribeActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
      .builder()
      .optionallyWith(
        userActivities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userActivities)
      .optionallyWith(
        marker.map(value => SearchMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeActivitiesResponse.wrap(buildAwsValue())
}
object DescribeActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeActivitiesResponse =
      zio.aws.workdocs.model.DescribeActivitiesResponse(
        userActivities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def userActivities: Optional[List[zio.aws.workdocs.model.Activity.ReadOnly]]
    def marker: Optional[SearchMarkerType]
    def getUserActivities
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.Activity.ReadOnly]] =
      AwsError.unwrapOptionField("userActivities", userActivities)
    def getMarker: ZIO[Any, AwsError, SearchMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ) extends zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly {
    override val userActivities
        : Optional[List[zio.aws.workdocs.model.Activity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userActivities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.Activity.wrap(item)
          }.toList
        )
    override val marker: Optional[SearchMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.SearchMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ): zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
