package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.NextMarkerType
import scala.jdk.CollectionConverters.*
final case class SearchResourcesResponse(
    items: Optional[Iterable[zio.aws.workdocs.model.ResponseItem]] =
      Optional.Absent,
    marker: Optional[NextMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse = {
    import SearchResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        marker.map(value => NextMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly =
    zio.aws.workdocs.model.SearchResourcesResponse.wrap(buildAwsValue())
}
object SearchResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.SearchResourcesResponse =
      zio.aws.workdocs.model.SearchResourcesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def items: Optional[List[zio.aws.workdocs.model.ResponseItem.ReadOnly]]
    def marker: Optional[NextMarkerType]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.ResponseItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getMarker: ZIO[Any, AwsError, NextMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse
  ) extends zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.workdocs.model.ResponseItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.ResponseItem.wrap(item)
          }.toList
        )
    override val marker: Optional[NextMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.NextMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse
  ): zio.aws.workdocs.model.SearchResourcesResponse.ReadOnly = new Wrapper(impl)
}
