package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait SearchResourceType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.SearchResourceType
}
object SearchResourceType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.SearchResourceType
  ): zio.aws.workdocs.model.SearchResourceType = value match {
    case software.amazon.awssdk.services.workdocs.model.SearchResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.SearchResourceType.FOLDER =>
      val r = FOLDER
      r
    case software.amazon.awssdk.services.workdocs.model.SearchResourceType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.workdocs.model.SearchResourceType.COMMENT =>
      val r = COMMENT
      r
    case software.amazon.awssdk.services.workdocs.model.SearchResourceType.DOCUMENT_VERSION =>
      val r = DOCUMENT_VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.SearchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SearchResourceType =
      software.amazon.awssdk.services.workdocs.model.SearchResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLDER extends zio.aws.workdocs.model.SearchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SearchResourceType =
      software.amazon.awssdk.services.workdocs.model.SearchResourceType.FOLDER
  }
  case object DOCUMENT extends zio.aws.workdocs.model.SearchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SearchResourceType =
      software.amazon.awssdk.services.workdocs.model.SearchResourceType.DOCUMENT
  }
  case object COMMENT extends zio.aws.workdocs.model.SearchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SearchResourceType =
      software.amazon.awssdk.services.workdocs.model.SearchResourceType.COMMENT
  }
  case object DOCUMENT_VERSION
      extends zio.aws.workdocs.model.SearchResourceType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.SearchResourceType =
      software.amazon.awssdk.services.workdocs.model.SearchResourceType.DOCUMENT_VERSION
  }
}
