package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  DocumentContentType,
  ResourceNameType,
  TimestampType,
  SizeType,
  AuthenticationHeaderType,
  ResourceIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class InitiateDocumentVersionUploadRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    id: Optional[ResourceIdType] = Optional.Absent,
    name: Optional[ResourceNameType] = Optional.Absent,
    contentCreatedTimestamp: Optional[TimestampType] = Optional.Absent,
    contentModifiedTimestamp: Optional[TimestampType] = Optional.Absent,
    contentType: Optional[DocumentContentType] = Optional.Absent,
    documentSizeInBytes: Optional[SizeType] = Optional.Absent,
    parentFolderId: Optional[ResourceIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest = {
    import InitiateDocumentVersionUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        contentCreatedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentCreatedTimestamp)
      .optionallyWith(
        contentModifiedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentModifiedTimestamp)
      .optionallyWith(
        contentType.map(value =>
          DocumentContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        documentSizeInBytes.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.documentSizeInBytes)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly =
    zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest
      .wrap(buildAwsValue())
}
object InitiateDocumentVersionUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest =
      zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest(
        authenticationToken.map(value => value),
        id.map(value => value),
        name.map(value => value),
        contentCreatedTimestamp.map(value => value),
        contentModifiedTimestamp.map(value => value),
        contentType.map(value => value),
        documentSizeInBytes.map(value => value),
        parentFolderId.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def id: Optional[ResourceIdType]
    def name: Optional[ResourceNameType]
    def contentCreatedTimestamp: Optional[TimestampType]
    def contentModifiedTimestamp: Optional[TimestampType]
    def contentType: Optional[DocumentContentType]
    def documentSizeInBytes: Optional[SizeType]
    def parentFolderId: Optional[ResourceIdType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getContentCreatedTimestamp: ZIO[Any, AwsError, TimestampType] = AwsError
      .unwrapOptionField("contentCreatedTimestamp", contentCreatedTimestamp)
    def getContentModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField(
        "contentModifiedTimestamp",
        contentModifiedTimestamp
      )
    def getContentType: ZIO[Any, AwsError, DocumentContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDocumentSizeInBytes: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("documentSizeInBytes", documentSizeInBytes)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ) extends zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val id: Optional[ResourceIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val name: Optional[ResourceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val contentCreatedTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentCreatedTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentModifiedTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentModifiedTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentType: Optional[DocumentContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.workdocs.model.primitives.DocumentContentType(value)
        )
    override val documentSizeInBytes: Optional[SizeType] = zio.aws.core.internal
      .optionalFromNullable(impl.documentSizeInBytes())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val parentFolderId: Optional[ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentFolderId())
        .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest
  ): zio.aws.workdocs.model.InitiateDocumentVersionUploadRequest.ReadOnly =
    new Wrapper(impl)
}
