package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workdocs.model.primitives.IdType
import scala.jdk.CollectionConverters.*
final case class DeleteNotificationSubscriptionRequest(
    subscriptionId: IdType,
    organizationId: IdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest = {
    import DeleteNotificationSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest
      .builder()
      .subscriptionId(IdType.unwrap(subscriptionId): java.lang.String)
      .organizationId(IdType.unwrap(organizationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest
      .wrap(buildAwsValue())
}
object DeleteNotificationSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest =
      zio.aws.workdocs.model
        .DeleteNotificationSubscriptionRequest(subscriptionId, organizationId)
    def subscriptionId: IdType
    def organizationId: IdType
    def getSubscriptionId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(subscriptionId)
    def getOrganizationId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(organizationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest
  ) extends zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest.ReadOnly {
    override val subscriptionId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.subscriptionId())
    override val organizationId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.organizationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest
  ): zio.aws.workdocs.model.DeleteNotificationSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
