package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{IdType, TimestampType, CommentIdType}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CommentMetadata(
    commentId: Optional[CommentIdType] = Optional.Absent,
    contributor: Optional[zio.aws.workdocs.model.User] = Optional.Absent,
    createdTimestamp: Optional[TimestampType] = Optional.Absent,
    commentStatus: Optional[zio.aws.workdocs.model.CommentStatusType] =
      Optional.Absent,
    recipientId: Optional[IdType] = Optional.Absent,
    contributorId: Optional[IdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CommentMetadata = {
    import CommentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CommentMetadata
      .builder()
      .optionallyWith(
        commentId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.commentId)
      .optionallyWith(contributor.map(value => value.buildAwsValue()))(
        _.contributor
      )
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(commentStatus.map(value => value.unwrap))(_.commentStatus)
      .optionallyWith(
        recipientId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.recipientId)
      .optionallyWith(
        contributorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.contributorId)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CommentMetadata.ReadOnly =
    zio.aws.workdocs.model.CommentMetadata.wrap(buildAwsValue())
}
object CommentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CommentMetadata =
      zio.aws.workdocs.model.CommentMetadata(
        commentId.map(value => value),
        contributor.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        commentStatus.map(value => value),
        recipientId.map(value => value),
        contributorId.map(value => value)
      )
    def commentId: Optional[CommentIdType]
    def contributor: Optional[zio.aws.workdocs.model.User.ReadOnly]
    def createdTimestamp: Optional[TimestampType]
    def commentStatus: Optional[zio.aws.workdocs.model.CommentStatusType]
    def recipientId: Optional[IdType]
    def contributorId: Optional[IdType]
    def getCommentId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("commentId", commentId)
    def getContributor
        : ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("contributor", contributor)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCommentStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentStatusType] =
      AwsError.unwrapOptionField("commentStatus", commentStatus)
    def getRecipientId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("recipientId", recipientId)
    def getContributorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("contributorId", contributorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ) extends zio.aws.workdocs.model.CommentMetadata.ReadOnly {
    override val commentId: Optional[CommentIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.commentId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val contributor: Optional[zio.aws.workdocs.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contributor())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
    override val createdTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val commentStatus
        : Optional[zio.aws.workdocs.model.CommentStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commentStatus())
        .map(value => zio.aws.workdocs.model.CommentStatusType.wrap(value))
    override val recipientId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.recipientId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val contributorId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.contributorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ): zio.aws.workdocs.model.CommentMetadata.ReadOnly = new Wrapper(impl)
}
