package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{AuthenticationHeaderType, IdType}
import scala.jdk.CollectionConverters.*
final case class ActivateUserRequest(
    userId: IdType,
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ActivateUserRequest = {
    import ActivateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ActivateUserRequest
      .builder()
      .userId(IdType.unwrap(userId): java.lang.String)
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ActivateUserRequest.ReadOnly =
    zio.aws.workdocs.model.ActivateUserRequest.wrap(buildAwsValue())
}
object ActivateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ActivateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ActivateUserRequest =
      zio.aws.workdocs.model
        .ActivateUserRequest(userId, authenticationToken.map(value => value))
    def userId: IdType
    def authenticationToken: Optional[AuthenticationHeaderType]
    def getUserId: ZIO[Any, Nothing, IdType] = ZIO.succeed(userId)
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ActivateUserRequest
  ) extends zio.aws.workdocs.model.ActivateUserRequest.ReadOnly {
    override val userId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.userId())
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ActivateUserRequest
  ): zio.aws.workdocs.model.ActivateUserRequest.ReadOnly = new Wrapper(impl)
}
