package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFolderPathResponse(
    path: Optional[zio.aws.workdocs.model.ResourcePath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse = {
    import GetFolderPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse
      .builder()
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly =
    zio.aws.workdocs.model.GetFolderPathResponse.wrap(buildAwsValue())
}
object GetFolderPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetFolderPathResponse =
      zio.aws.workdocs.model
        .GetFolderPathResponse(path.map(value => value.asEditable))
    def path: Optional[zio.aws.workdocs.model.ResourcePath.ReadOnly]
    def getPath
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourcePath.ReadOnly] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse
  ) extends zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly {
    override val path: Optional[zio.aws.workdocs.model.ResourcePath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.path())
        .map(value => zio.aws.workdocs.model.ResourcePath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse
  ): zio.aws.workdocs.model.GetFolderPathResponse.ReadOnly = new Wrapper(impl)
}
